% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/region_matrix.R
\name{get_region_matrix}
\alias{get_region_matrix}
\title{Get Matrix with Regions for Strucs.}
\usage{
get_region_matrix(
  corpus,
  s_attribute,
  strucs,
  registry = Sys.getenv("CORPUS_REGISTRY")
)
}
\arguments{
\item{corpus}{a CWB corpus}

\item{s_attribute}{a structural attribute}

\item{strucs}{strucs}

\item{registry}{the registry directory}
}
\value{
A matrix with integer values indicating left and right corpus positions
(columns 1 and 2, respectively).
}
\description{
The return value is an integer matrix with the left and right corpus positions
of the strucs in columns one and two, respectively.
}
\examples{
registry <- if (!check_pkg_registry_files()) use_tmp_registry() else get_pkg_registry()
y <- get_region_matrix(
  corpus = "REUTERS", s_attribute = "id",
  strucs = 0L:5L, registry = registry
  )
}
