# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Linear Regression with L-BFGS
#'
#' Solves the Linear Regression's Residual Sum of Squares using the L-BFGS
#' optimizer.
#'
#' @param X A `matrix` that is the Design Matrix for the regression problem.
#' @param y A `vec` containing the response values.
#'
#' @return
#' The estimated \eqn{\beta}{beta} parameter values for the linear regression.
#' @details
#' Consider the **Residual Sum of Squares**, also known as **RSS**, defined as:
#' \deqn{RSS\left( \beta \right) = \left( { \mathbf{y} - \mathbf{X} \beta } \right)^{T} \left( \mathbf{y} - \mathbf{X} \beta \right)}{RSS(beta) = (y - X*beta)^T * (y - X*beta)}
#' The objective function is defined as:
#' \deqn{f(\beta) = (y - X\beta)^2}{f(beta) = (y - X * beta)^2}
#' The gradient is defined as:
#' \deqn{\frac{\partial RSS}{\partial \beta} = -2 \mathbf{X}^{T} \left(\mathbf{y} - \mathbf{X} \beta \right)}{dRSS/dbeta = -2 X^T (y - X * beta)}
#' @export
#' @examples
#' # Number of Points
#' n = 1000
#'
#' # Select beta parameters
#' beta = c(-2, 1.5, 3, 8.2, 6.6)
#'
#' # Number of Predictors (including intercept)
#' p = length(beta)
#'
#' # Generate predictors from a normal distribution
#' X_i = matrix(rnorm(n), ncol = p - 1)
#'
#' # Add an intercept
#' X = cbind(1, X_i)
#'
#' # Generate y values
#' y = X%*%beta + rnorm(n / (p - 1))
#'
#' # Run optimization with lbfgs
#' theta_hat = lin_reg_lbfgs(X, y)
#'
#' # Verify parameters were recovered
#' cbind(actual = beta, estimated = theta_hat)
lin_reg_lbfgs <- function(X, y) {
    .Call(`_RcppEnsmallen_lin_reg_lbfgs`, X, y)
}

