# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Faddeeva family of error functions of the complex variable
#' @description the Faddeeva function
#' @param z complex vector
#' @param relerr double, requested error
#' @return complex vector
#' @describeIn wrap compute w(z) = exp(-z^2) erfc(-iz)
#' @family wrapper
#' @examples 
#' Faddeeva_w(1:10 + 1i)
#' @export
Faddeeva_w <- function(z, relerr = 0) {
    .Call('RcppFaddeeva_Faddeeva_w', PACKAGE = 'RcppFaddeeva', z, relerr)
}

#' the scaled complementary error function
#' @inheritParams Faddeeva_w 
#' @describeIn wrap compute erfcx(z) = exp(z^2) erfc(z)
#' @family wrapper
#' @examples 
#' erfcx(1:10 + 1i)
#' @export
erfcx <- function(z, relerr = 0) {
    .Call('RcppFaddeeva_erfcx', PACKAGE = 'RcppFaddeeva', z, relerr)
}

#'  the error function of complex arguments
#' @inheritParams Faddeeva_w 
#' @describeIn wrap compute erf(z)
#' @family wrapper
#' @examples 
#' erf(1:10 + 1i)
#' @export
erf <- function(z, relerr = 0) {
    .Call('RcppFaddeeva_erf', PACKAGE = 'RcppFaddeeva', z, relerr)
}

#' the imaginary error function 
#' @inheritParams Faddeeva_w 
#' @describeIn wrap compute erfi(z) = -i erf(iz)
#' @family wrapper
#' @examples 
#' erfi(1:10 + 1i)
#' @export
erfi <- function(z, relerr = 0) {
    .Call('RcppFaddeeva_erfi', PACKAGE = 'RcppFaddeeva', z, relerr)
}

#' the complementary error function
#' @inheritParams Faddeeva_w 
#' @describeIn wrap compute erfc(z) = 1 - erf(z)
#' @family wrapper
#' @examples 
#' erfc(1:10 + 1i)
#' @export
erfc <- function(z, relerr = 0) {
    .Call('RcppFaddeeva_erfc', PACKAGE = 'RcppFaddeeva', z, relerr)
}

#' the Dawson function
#' @inheritParams Faddeeva_w 
#' @describeIn wrap compute Dawson(z) = sqrt(pi)/2  *  exp(-z^2) * erfi(z)
#' @family wrapper
#' @examples 
#' Dawson(1:10 + 1i)
#' @export
Dawson <- function(z, relerr = 0) {
    .Call('RcppFaddeeva_Dawson', PACKAGE = 'RcppFaddeeva', z, relerr)
}

