% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hnsw.R
\name{hnsw_build}
\alias{hnsw_build}
\title{Build an hnswlib nearest neighbor index}
\usage{
hnsw_build(X, distance = "euclidean", M = 16, ef = 200,
  verbose = FALSE)
}
\arguments{
\item{X}{a numeric matrix of data to add. Each of the n rows is an item in
the index.}

\item{distance}{Type of distance to calculate. One of:
\itemize{
  \item \code{"l2"} Squared L2, i.e. squared Euclidean.
  \item \code{"euclidean"} Euclidean.
  \item \code{"cosine"} Cosine.
  \item \code{"ip"} Inner product: 1 - sum(ai * bi), i.e. the cosine distance
  where the vectors are not normalized. This can lead to negative distances
  and other non-metric behavior.
}}

\item{M}{Controls the number of bi-directional links created for each element
during index construction. Higher values lead to better results at the
expense of memory consumption. Typical values are \code{2 - 100}, but
for most datasets a range of \code{12 - 48} is suitable. Can't be smaller
than 2.}

\item{ef}{Size of the dynamic list used during construction.
A larger value means a better quality index, but increases build time.
Should be an integer value between 1 and the size of the dataset.}

\item{verbose}{If \code{TRUE}, log progress to the console.}
}
\value{
an instance of a \code{HnswL2}, \code{HnswCosine} or \code{HnswIp}
  class.
}
\description{
Build an hnswlib nearest neighbor index
}
\examples{
irism <- as.matrix(iris[, -5])
ann <- hnsw_build(irism)
iris_nn <- hnsw_search(irism, ann, k = 5)
}
