% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{aux.preprocess}
\alias{aux.preprocess}
\title{Centering, decorrelating, or whitening of the data}
\usage{
aux.preprocess(data, type = "center")
}
\arguments{
\item{data}{an \eqn{(n-by-p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{type}{one of "center", "decorrelate", or "whiten". See below for more details.}
}
\value{
named list containing:
\describe{
\item{pX}{an \eqn{(n-by-p)} matrix after preprocessing in accordance with \code{type} parameter}
\item{info}{a list containing \itemize{
\item \code{type:} name of preprocessing procedure.
\item \code{mean:} a mean vector of length \eqn{p}.
\item \code{multiplier:} a \eqn{(p-by-p)} matrix for "decorrelate" or "whiten" or 1 for "center".}}
}
}
\description{
\code{aux.preprocess} can perform one of three popular operations; centering, decorrelating,
 and whitening of data. See below for more details.
}
\details{
\code{"center"} option subtracts mean of each column so that every variable has
mean 0. After centering, option \code{"decorrelate"} sets the data matrix
to have diagonal covariance terms only. \code{"whiten"} option sets the sample
covariance to have all diagonal terms equal to 1, equally weighting each variable.
}
\examples{
## Generate data
X = aux.gensamples()

## 3 types of preprocessing
X_center = aux.preprocess(X)
X_decorr = aux.preprocess(X,type="decorrelate")
X_whiten = aux.preprocess(X,type="whiten")

## Check with Covariance matrix
par(mfrow=c(1,3))
image(cov(X_center$pX),zlim=c(-50,50)); title("center");
image(cov(X_decorr$pX),zlim=c(-50,50)); title("decorrelate");
image(cov(X_whiten$pX),zlim=c(-50,50)); title("whitening")

}
\author{
Kisung You
}
