% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_SAMMON.R
\name{do.sammon}
\alias{do.sammon}
\title{Sammon Mapping}
\usage{
do.sammon(X, ndim = 2, preprocess = "null", initialize = "random")
}
\arguments{
\item{X}{an \code{(n-by-p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null" and three options of "center", "decorrelate", or "whiten"
are supported. See also \code{\link{aux.preprocess}} for more details.}

\item{initialize}{\code{"random"} or \code{"pca"}; the former performs
fast random projection (see also \code{\link{do.rndproj}}) and the latter
performs standard PCA (see also \code{\link{do.pca}}).}
}
\value{
a named list containing
\describe{
\item{Y}{an \code{(n-by-ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
\code{do.sammon} is an implementation for Sammon mapping, one of the earliest
dimension reduction techniques that aims to find low-dimensional embedding
that preserves pairwise distance structure in high-dimensional data space.
}
\examples{
## generate default dataset
## in order to pass CRAN pretest, n is set to be small.
X <- aux.gensamples(n=28)

## compare two initialization
out1 = do.sammon(X,ndim=2)                   # random projection
out2 = do.sammon(X,ndim=2,initialize="pca")  # pca as initialization

par(mfrow=c(1,2))
plot(out1$Y[,1],out1$Y[,2],main="out1:rndproj")
plot(out2$Y[,1],out2$Y[,2],main="out2:pca")

}
\references{
Sammon, J.W. (1969) \emph{A Nonlinear Mapping for Data Structure Analysis}.
IEEE Transactions on Computers, C-18 5:401-409.

\insertRef{sammon_nonlinear_1969}{Rdimtools}
}
\author{
Kisung You
}
