% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_PCA.R
\name{do.pca}
\alias{do.pca}
\title{Principal Component Analysis}
\usage{
do.pca(X, ndim = "auto", cor = FALSE, preprocess = "center",
  varratio = 0.9)
}
\arguments{
\item{X}{an \code{(n-by-p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension or ``auto'' option using \emph{varratio.}}

\item{cor}{mode of eigendecomposition. \code{FALSE} for decomposing covariance matrix,
and \code{TRUE} for correlation matrix.}

\item{preprocess}{an option for preprocessing the data. This supports three methods,
``center'',``decorrelate'', or ``whiten''. See also \code{\link{aux.preprocess}}
for more details.}

\item{varratio}{a value in (0,1]. This value is only used when \code{ndim} is
chosen as ``auto''.}
}
\value{
a named list containing
\describe{
\item{Y}{an \code{(n-by-ndim)} matrix whose rows are embedded observations.}
\item{vars}{a vector containing variances of projected data onto principal components.}
\item{projection}{a \code{(p-by-ndim)} whose columns are principal components.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
\code{do.pca} performs a classical principal component analysis (PCA) using
\code{RcppArmadillo} package for faster and efficient computation.
}
\details{
A combination of \code{ndim="auto"} and \code{varratio} options is to
automatically decide the target dimension based on cumulative sum of
variance. Measured by summation of top eigenvalues from sample covariance,
we use the minimal summation to be larger than \code{varratio}.
}
\examples{
# generate data
X <- rbind(matrix(rnorm(100),nr=10),matrix(rnorm(100),nr=10)+10)

## 1. projection using 2 principal components
output <- do.pca(X,ndim=2)
plot(output$Y[,1],output$Y[,2])

## 2. automatic detection of target dimension accounting for 98\% of variance
output <- do.pca(X,ndim="auto",varratio=0.98)           # perform PCA
plot(seq_len(length(output$vars)),output$vars,type="b") # plot variances
}
\references{
\insertRef{pearson_liii._1901}{Rdimtools}
}
\author{
Kisung You
}
