% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_SLPE.R
\name{do.slpe}
\alias{do.slpe}
\title{Supervised Locality Pursuit Embedding}
\usage{
do.slpe(X, label, ndim = 2, preprocess = c("center", "decorrelate",
  "whiten"))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center" and other options of "decorrelate" and "whiten"
are supported. See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Supervised Locality Pursuit Embedding (SLPE) is a supervised extension of LPE
that uses class labels of data points in order to enhance discriminating power in
its mapping into a low dimensional space.
}
\examples{
\dontrun{
## generate data of 2 types with clear difference
diff = 15
dt1  = aux.gensamples(n=123)-diff;
dt2  = aux.gensamples(n=123)+diff;

## merge the data and create a label correspondingly
X      = rbind(dt1,dt2)
label  = c(rep(1,123), rep(2,123))

## compare SLPE with SLPP
out1 <- do.slpp(X, label)
out2 <- do.slpe(X, label)

## visualize
par(mfrow=c(1,2))
plot(out1$Y[,1], out1$Y[,2], main="SLPP")
plot(out2$Y[,1], out2$Y[,2], main="SLPE")
}

}
\references{
\insertRef{zheng_supervised_2006}{Rdimtools}
}
\seealso{
\code{\link{do.lpe}}
}
\author{
Kisung You
}
