% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_SPMDS.R
\name{do.spmds}
\alias{do.spmds}
\title{Spectral Multidimensional Scaling}
\usage{
do.spmds(X, ndim = 2, neigs = max(2, nrow(X)/10), ratio = 0.1,
  preprocess = c("null", "center", "scale", "cscale", "decorrelate",
  "whiten"), type = c("proportion", 0.1), symmetric = c("union",
  "intersect", "asymmetric"))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{neigs}{number of eigenvectors to be used as \emph{spectral dimension}.}

\item{ratio}{percentage of subsamples as reference points.}

\item{preprocess}{an additional option for preprocessing the data.
Default is \code{"null"}. See also \code{\link{aux.preprocess}} for more details.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{symmetric}{one of \code{"intersect"}, \code{"union"} or \code{"asymmetric"} is supported. Default is \code{"union"}. See also \code{\link{aux.graphnbd}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
\code{do.spmds} transfers the classical multidimensional scaling problem into
the data spectral domain using Laplace-Beltrami operator. Its flexibility
to use subsamples and spectral interpolation of non-reference data enables relatively
efficient computation for large-scale data.
}
\examples{
\dontrun{
## Replicate the numerical example from the paper
#  Data Preparation
dim.true  = 3     # true dimension
dim.embed = 100   # embedding space (high-d)
npoints   = 1000  # number of samples to be generated

v     = matrix(runif(dim.embed*dim.true),ncol=dim.embed)
coeff = matrix(runif(dim.true*npoints),  ncol=dim.true)
X     = coeff\%*\%v

# see the effect of neighborhood size
out1  = do.spmds(X, neigs=100, type=c("proportion",0.1))
out2  = do.spmds(X, neigs=100, type=c("proportion",0.25))
out3  = do.spmds(X, neigs=100, type=c("proportion",0.50))

# visualize the results
par(mfrow=c(1,3))
plot(out1$Y[,1],out1$Y[,2],main="10\% neighborhood")
plot(out2$Y[,1],out2$Y[,2],main="25\% neighborhood")
plot(out3$Y[,1],out3$Y[,2],main="50\% neighborhood")
}

}
\references{
\insertRef{aflalo_spectral_2013}{Rdimtools}
}
\author{
Kisung You
}
