% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_nearneighbor2.R
\name{est.nearneighbor2}
\alias{est.nearneighbor2}
\title{Near-Neighbor Information with Bias Correction}
\usage{
est.nearneighbor2(X, kmin = 2, kmax = max(3, round(ncol(X)/2)))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{kmin}{minimum neighborhood size, larger than 1.}

\item{kmax}{maximum neighborhood size, smaller than \eqn{p}.}
}
\value{
a named list containing containing \describe{
\item{estdim}{estimated intrinsic dimension.}
}
}
\description{
Though similar to \code{\link{est.nearneighbor1}}, authors of the reference
argued that there exists innate bias in the method and proposed a non-iterative algorithm
to reflect local distance information under a range of neighborhood sizes.
}
\examples{
\dontrun{
## create an example data with intrinsic dimension 2
X = cbind(aux.gensamples(dname="swiss"),aux.gensamples(dname="swiss"))

## acquire an estimate for intrinsic dimension
output = est.nearneighbor2(X)
sprintf("* est.nearneighbor2 : estimated dimension is \%.2f.",output$estdim)
}

}
\references{
\insertRef{verveer_evaluation_1995}{Rdimtools}
}
