% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_LMDS.R
\name{do.lmds}
\alias{do.lmds}
\title{Landmark Multidimensional Scaling}
\usage{
do.lmds(X, ndim = 2, ltype = "random", npoints = max(nrow(X)/5, ndim
  + 1), preprocess = c("center", "cscale", "decorrelate", "whiten"))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{ltype}{on how to select landmark points, either \code{"random"} or \code{"MaxMin"}.}

\item{npoints}{the number of landmark points to be drawn.}

\item{preprocess}{an option for preprocessing the data. Default is "center".
See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Landmark MDS is a variant of Classical Multidimensional Scaling in that
it first finds a low-dimensional embedding using a small portion of given dataset
and graft the others in a manner to preserve as much pairwise distance from
all the other data points to landmark points as possible.
}
\examples{
\dontrun{
# generate data
X <- aux.gensamples(dname="crown")

## 1. use 10\% of random points
output1 <- do.lmds(X,ndim=2,npoints=round(nrow(X)/10))

## 2. using MaxMin scheme
output2 <- do.lmds(X,ndim=2,npoints=round(nrow(X)/10),ltype="MaxMin")

## 3. original mds case
output3 <- do.mds(X,ndim=2)

## Visualization
par(mfrow=c(1,3))
plot(output1$Y[,1],output2$Y[,2],main="10\% random points")
plot(output2$Y[,1],output2$Y[,2],main="10\% MaxMin points")
plot(output3$Y[,1],output3$Y[,2],main="original MDS")
}

}
\references{
\insertRef{silva_global_2002}{Rdimtools}

\insertRef{lee_landmark_2009}{Rdimtools}
}
\seealso{
\code{\link{do.mds}}
}
\author{
Kisung You
}
