% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_MODP.R
\name{do.modp}
\alias{do.modp}
\title{Modified Orthogonal Discriminant Projection}
\usage{
do.modp(X, label, ndim = 2, preprocess = c("center", "scale", "cscale",
  "decorrelate", "whiten"), type = c("proportion", 0.1),
  symmetric = c("union", "intersect", "asymmetric"), alpha = 0.5,
  beta = 10)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{symmetric}{one of \code{"intersect"}, \code{"union"} or \code{"asymmetric"} is supported. Default is \code{"union"}. See also \code{\link{aux.graphnbd}} for more details.}

\item{alpha}{balancing parameter of non-local and local scatter in \eqn{[0,1]}.}

\item{beta}{scaling control parameter for distant pairs of data in \eqn{(0,\infty)}.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Modified Orthogonal Discriminant Projection (MODP) is a variant of Orthogonal Discriminant Projection (ODP).
Authors argue the assumption in modeling ODP's mechanism to reflect distance and class labeling seem unsound.
They propose a modified method to explore the intrinsic structure of original data and enhance
the classification ability.
}
\examples{
## generate 3 different groups of data X and label vector
x1 = matrix(rnorm(4*10), nrow=10)-20
x2 = matrix(rnorm(4*10), nrow=10)
x3 = matrix(rnorm(4*10), nrow=10)+20
X  = rbind(x1, x2, x3)
label = c(rep(1,10), rep(2,10), rep(3,10))

## try different beta (scaling control) parameter
out1 = do.modp(X, label, beta=1)
out2 = do.modp(X, label, beta=10)
out3 = do.modp(X, label, beta=100)

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="modp::beta=1")
plot(out2$Y[,1], out2$Y[,2], main="modp::beta=10")
plot(out3$Y[,1], out3$Y[,2], main="modp::beta=100")

}
\references{
\insertRef{zhang_modified_2011}{Rdimtools}
}
