% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_clustering.R
\name{est.clustering}
\alias{est.clustering}
\title{Intrinsic Dimension Estimation via Clustering}
\usage{
est.clustering(X, kmin = round(sqrt(nrow(X))))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{kmin}{minimal number of neighborhood size to search over.}
}
\value{
a named list containing containing \describe{
\item{estdim}{estimated intrinsic dimension.}
}
}
\description{
Instead of directly using neighborhood information, \code{est.clustering} adopts hierarchical
neighborhood information using \code{\link[stats]{hclust}} by recursively merging leafs
over the range of radii.
}
\examples{
\donttest{
## create 'swiss' roll dataset
X = aux.gensamples(dname="swiss")

## try different k values
out1 = est.clustering(X, kmin=5)
out2 = est.clustering(X, kmin=25)
out3 = est.clustering(X, kmin=50)

## print the results
sprintf("* est.clustering : estimated dimension with kmin=5  is \%.2f.",out1$estdim)
sprintf("* est.clustering : estimated dimension with kmin=25 is \%.2f.",out2$estdim)
sprintf("* est.clustering : estimated dimension with kmin=50 is \%.2f.",out3$estdim)
}

}
\references{
\insertRef{eriksson_estimating_2012}{Rdimtools}
}
\author{
Kisung You
}
