% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_LLP.R
\name{do.llp}
\alias{do.llp}
\title{Local Learning Projections}
\usage{
do.llp(
  X,
  ndim = 2,
  type = c("proportion", 0.1),
  symmetric = c("union", "intersect", "asymmetric"),
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten"),
  t = 1,
  lambda = 1
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{symmetric}{one of \code{"intersect"}, \code{"union"} or \code{"asymmetric"} is supported. Default is \code{"union"}.
See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{t}{bandwidth for heat kernel in \eqn{(0,\infty)}.}

\item{lambda}{regularization parameter for kernel matrix in \eqn{[0,\infty)}.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
While Principal Component Analysis (PCA) aims at minimizing global estimation error, Local Learning
Projection (LLP) approach tries to find the projection with the minimal \emph{local}
estimation error in the sense that each projected datum can be well represented
based on ones neighbors. For the kernel part, we only enabled to use
a gaussian kernel as suggested from the original paper. The parameter \code{lambda}
controls possible rank-deficiency of kernel matrix.
}
\examples{
\donttest{
## generate data
X <- aux.gensamples(dname="crown")

## test different lambda - regularization - values
out1 <- do.llp(X,ndim=2,lambda=0.1)
out2 <- do.llp(X,ndim=2,lambda=1)
out3 <- do.llp(X,ndim=2,lambda=10)

# visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, main="lambda = 0.1")
plot(out2$Y, main="lambda = 1")
plot(out3$Y, main="lambda = 10")
par(opar)
}

}
\references{
\insertRef{wu_local_2007}{Rdimtools}
}
