% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_RSR.R
\name{do.rsr}
\alias{do.rsr}
\title{Regularized Self-Representation}
\usage{
do.rsr(
  X,
  ndim = 2,
  preprocess = c("null", "center", "scale", "cscale", "whiten", "decorrelate"),
  lbd = 1
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{lbd}{nonnegative number to control the degree of self-representation by imposing row-sparsity.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{featidx}{a length-\eqn{ndim} vector of indices with highest scores.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Given a data matrix \eqn{X} where observations are stacked in a row-wise manner,
Regularized Self-Representation (RSR) aims at finding a solution to following optimization problem
\deqn{\textrm{min}~ \|X-XW\|_{2,1} + \lambda \| W \|_{2,1}}
where \eqn{\|W\|_{2,1} = \sum_{i=1}^{m} \|W_{i:} \|_2} is an \eqn{\ell_{2,1}} norm that imposes
row-wise sparsity constraint.
}
\examples{
\donttest{
## load iris data
data(iris)
set.seed(100)
subid = sample(1:150,50)
X     = as.matrix(iris[subid,1:4])
label = as.factor(iris[subid,5])

#### try different lbd combinations
out1 = do.rsr(X, lbd=0.1)
out2 = do.rsr(X, lbd=1)
out3 = do.rsr(X, lbd=10)

#### visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, pch=19, col=label, main="RSR::lbd=0.1")
plot(out2$Y, pch=19, col=label, main="RSR::lbd=1")
plot(out3$Y, pch=19, col=label, main="RSR::lbd=10")
par(opar)
}

}
\references{
\insertRef{zhu_unsupervised_2015}{Rdimtools}
}
\author{
Kisung You
}
\concept{linear_methods}
