% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_SPECS.R
\name{do.specs}
\alias{do.specs}
\title{Supervised Spectral Feature Selection}
\usage{
do.specs(
  X,
  label,
  ndim = 2,
  ranking = c("method1", "method2", "method3"),
  preprocess = c("null", "center", "scale", "cscale", "whiten", "decorrelate")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{ranking}{types of feature scoring method. See the paper in the reference for more details.}

\item{preprocess}{an additional option for preprocessing the data. Default is "null". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{sscore}{a length-\eqn{p} vector of spectral feature scores.}
\item{featidx}{a length-\eqn{ndim} vector of indices with highest scores.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
SPEC algorithm selects features from the data via spectral graph approach.
Three types of ranking methods that appeared in the paper are available where
the graph laplacian is built via class label information.
}
\examples{
\donttest{
## use iris data
## it is known that feature 3 and 4 are more important.
data(iris)
set.seed(100)
subid = sample(1:150, 50)
iris.dat = as.matrix(iris[subid,1:4])
iris.lab = as.factor(iris[subid,5])

## try different ranking methods
out1 = do.specs(iris.dat, iris.lab, ranking="method1")
out2 = do.specs(iris.dat, iris.lab, ranking="method2")
out3 = do.specs(iris.dat, iris.lab, ranking="method3")

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, pch=19, col=iris.lab, main="SPECS::method1")
plot(out2$Y, pch=19, col=iris.lab, main="SPECS::method2")
plot(out3$Y, pch=19, col=iris.lab, main="SPECS::method3")
par(opar)
}

}
\references{
\insertRef{zhao_spectral_2007}{Rdimtools}
}
\seealso{
\code{\link{do.specu}}
}
\author{
Kisung You
}
\concept{linear_methods}
