% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v_linear_LDA.R
\name{do.lda}
\alias{do.lda}
\title{Linear Discriminant Analysis}
\usage{
do.lda(X, label, ndim = 2)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
Linear Discriminant Analysis (LDA) originally aims to find a set of features
that best separate groups of data. Since we need \emph{label} information,
LDA belongs to a class of supervised methods of performing classification.
However, since it is based on finding \emph{suitable} projections, it can still
be used to do dimension reduction. We support both binary and multiple-class cases.
Note that the target dimension \code{ndim} should be \emph{less than or equal to} \code{K-1},
where \code{K} is the number of classes, or \code{K=length(unique(label))}. Our code
automatically gives bounds on user's choice to correspond to what theory has shown. See
the comments section for more details.
}
\section{Limit of Target Dimension Selection}{

In unsupervised algorithms, selection of \code{ndim} is arbitrary as long as
the target dimension is lower-dimensional than original data dimension, i.e., \code{ndim < p}.
In LDA, it is \emph{not allowed}. Suppose we have \code{K} classes, then its formulation on
\eqn{S_B}, between-group variance, has maximum rank of \code{K-1}. Therefore, the maximal
subspace can only be spanned by at most \code{K-1} orthogonal vectors.
}

\examples{
\donttest{
## use iris dataset
data(iris)
X     = as.matrix(iris[,1:4])
lab   = as.factor(iris[,5])

## compare with PCA
outLDA = do.lda(X, lab, ndim=2)
outPCA = do.pca(X, ndim=2)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2))
plot(outLDA$Y, col=lab, pch=19, main="LDA")
plot(outPCA$Y, col=lab, pch=19, main="PCA")
par(opar)
}

}
\references{
\insertRef{fisher_use_1936}{Rdimtools}

\insertRef{fukunaga_introduction_1990}{Rdimtools}
}
\author{
Kisung You
}
\concept{linear_methods}
