% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v_nonlinear_PHATE.R
\name{do.phate}
\alias{do.phate}
\title{Potential of Heat Diffusion for Affinity-based Transition Embedding}
\usage{
do.phate(
  X,
  ndim = 2,
  k = 5,
  alpha = 10,
  dtype = c("sqrt", "log"),
  smacof = TRUE,
  ...
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension (default: 2).}

\item{k}{size of nearest neighborhood (default: 5).}

\item{alpha}{decay parameter for Gaussian kernel exponent (default: 10).}

\item{dtype}{type of potential distance transformation; \code{"log"} or \code{"sqrt"} (default: \code{"sqrt"}).}

\item{smacof}{a logical; \code{TRUE} to use SMACOF for Metric MDS or \code{FALSE} to use Classical MDS (default: \code{TRUE}).}

\item{...}{extra parameters including \describe{
\item{maxiter}{maximum number of iterations (default: 100).}
\item{abstol}{absolute stopping criterion for metric MDS iterations (default: 1e-8).}
}}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
PHATE is a nonlinear method that is specifically targeted at visualizing
high-dimensional data by embedding it on 2- or 3-dimensional space. We offer
a native implementation of PHATE solely in R/C++ without interface to python module.
}
\examples{
\donttest{
## load iris data
data(iris)
X     = as.matrix(iris[,1:4])
lab   = as.factor(iris[,5])

## compare different neighborhood sizes.
pca2d <- do.pca(X, ndim=2)
phk01 <- do.phate(X, ndim=2, k=2)
phk02 <- do.phate(X, ndim=2, k=5)
phk03 <- do.phate(X, ndim=2, k=7)

## Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(2,2))
plot(pca2d$Y, col=lab, pch=19, main="PCA")
plot(phk01$Y, col=lab, pch=19, main="PHATE:k=2")
plot(phk02$Y, col=lab, pch=19, main="PHATE:k=5")
plot(phk03$Y, col=lab, pch=19, main="PHATE:k=7")
par(opar)
}

}
\references{
\insertRef{moon_visualizing_2019}{Rdimtools}
}
\concept{nonlinear_methods}
