% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maximize.g.r
\name{maximize.g}
\alias{maximize.g}
\title{maximize.g - Find coordinate of function maximum}
\usage{
maximize.g(fit, covars = NULL)
}
\arguments{
\item{fit}{An estimated 'dfunc' object produced by \code{dfuncEstim}.}

\item{covars}{Covariate values to calculate g(x).}
}
\value{
The value of x that maximizes g(x) in \code{fit}.
}
\description{
Find the x coordinate that maximizes g(x).
}
\examples{
\dontrun{
# Fake data
set.seed(22223333)
x <- rgamma(100, 10, 1)

fit <- dfuncEstim( x, likelihood="Gamma", x.scl="max" )

maximize.g( fit )  # should be near 10.
fit$x.scl            # same thing
}

}
\seealso{
\code{\link{dfuncEstim}}
}
\keyword{model}
