/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import antlr.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.State;
import org.antlr.analysis.Transition;
import org.antlr.misc.MultiMap;
import org.antlr.misc.Utils;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionProbe {
    public DFA dfa;
    protected Set<DFAState> statesWithSyntacticallyAmbiguousAltsSet = new HashSet<DFAState>();
    protected Map<DFAState, Set<Integer>> stateToSyntacticallyAmbiguousTokensRuleAltsMap = new HashMap<DFAState, Set<Integer>>();
    protected Set<DFAState> statesResolvedWithSemanticPredicatesSet = new HashSet<DFAState>();
    protected Map<DFAState, Map<Integer, SemanticContext>> stateToAltSetWithSemanticPredicatesMap = new HashMap<DFAState, Map<Integer, SemanticContext>>();
    protected Map<DFAState, Map<Integer, Set<Token>>> stateToIncompletelyCoveredAltsMap = new HashMap<DFAState, Map<Integer, Set<Token>>>();
    protected Set<DFAState> danglingStates = new HashSet<DFAState>();
    protected Set<Integer> altsWithProblem = new HashSet<Integer>();
    public boolean nonLLStarDecision = false;
    protected MultiMap<Integer, NFAConfiguration> stateToRecursionOverflowConfigurationsMap = new MultiMap();
    protected boolean timedOut = false;
    protected Map<Integer, Integer> stateReachable;
    public static final Integer REACHABLE_BUSY = Utils.integer(-1);
    public static final Integer REACHABLE_NO = Utils.integer(0);
    public static final Integer REACHABLE_YES = Utils.integer(1);
    protected Set<String> statesVisitedAtInputDepth;
    protected Set<Integer> statesVisitedDuringSampleSequence;
    public static boolean verbose = false;

    public DecisionProbe(DFA dfa) {
        this.dfa = dfa;
    }

    public String getDescription() {
        return this.dfa.getNFADecisionStartState().getDescription();
    }

    public boolean isReduced() {
        return this.dfa.isReduced();
    }

    public boolean isCyclic() {
        return this.dfa.isCyclic();
    }

    public boolean isDeterministic() {
        if (this.danglingStates.size() == 0 && this.statesWithSyntacticallyAmbiguousAltsSet.size() == 0 && this.dfa.getUnreachableAlts().size() == 0) {
            return true;
        }
        if (this.statesWithSyntacticallyAmbiguousAltsSet.size() > 0) {
            for (DFAState d : this.statesWithSyntacticallyAmbiguousAltsSet) {
                if (this.statesResolvedWithSemanticPredicatesSet.contains(d)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean analysisOverflowed() {
        return this.stateToRecursionOverflowConfigurationsMap.size() > 0;
    }

    public boolean isNonLLStarDecision() {
        return this.nonLLStarDecision;
    }

    public int getNumberOfStates() {
        return this.dfa.getNumberOfStates();
    }

    public List<Integer> getUnreachableAlts() {
        return this.dfa.getUnreachableAlts();
    }

    public Set getDanglingStates() {
        return this.danglingStates;
    }

    public Set getNonDeterministicAlts() {
        return this.altsWithProblem;
    }

    public List getNonDeterministicAltsForState(DFAState targetState) {
        Set nondetAlts = targetState.getNonDeterministicAlts();
        if (nondetAlts == null) {
            return null;
        }
        LinkedList sorted = new LinkedList();
        sorted.addAll(nondetAlts);
        Collections.sort(sorted);
        return sorted;
    }

    public Set getDFAStatesWithSyntacticallyAmbiguousAlts() {
        return this.statesWithSyntacticallyAmbiguousAltsSet;
    }

    public Set getDisabledAlternatives(DFAState d) {
        return d.getDisabledAlternatives();
    }

    public void removeRecursiveOverflowState(DFAState d) {
        Integer stateI = Utils.integer(d.stateNumber);
        this.stateToRecursionOverflowConfigurationsMap.remove(stateI);
    }

    public List<Label> getSampleNonDeterministicInputSequence(DFAState targetState) {
        Set dfaStates = this.getDFAPathStatesToTarget(targetState);
        this.statesVisitedDuringSampleSequence = new HashSet<Integer>();
        ArrayList<Label> labels = new ArrayList<Label>();
        if (this.dfa == null || this.dfa.startState == null) {
            return labels;
        }
        this.getSampleInputSequenceUsingStateSet(this.dfa.startState, targetState, dfaStates, labels);
        return labels;
    }

    public String getInputSequenceDisplay(List labels) {
        Grammar g = this.dfa.nfa.grammar;
        StringBuffer buf = new StringBuffer();
        Iterator it = labels.iterator();
        while (it.hasNext()) {
            Label label = (Label)it.next();
            buf.append(label.toString(g));
            if (!it.hasNext() || g.type == 1) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public List getNFAPathStatesForAlt(int firstAlt, int alt, List labels) {
        NFAState nfaStart = this.dfa.getNFADecisionStartState();
        LinkedList<NFAState> path = new LinkedList<NFAState>();
        for (int a = firstAlt; a <= alt; ++a) {
            NFAState s = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(nfaStart, a);
            path.add(s);
        }
        NFAState altStart = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(nfaStart, alt);
        NFAState isolatedAltStart = (NFAState)altStart.transition[0].target;
        path.add(isolatedAltStart);
        this.statesVisitedAtInputDepth = new HashSet<String>();
        this.getNFAPath(isolatedAltStart, 0, labels, path);
        return path;
    }

    public SemanticContext getSemanticContextForAlt(DFAState d, int alt) {
        Map<Integer, SemanticContext> altToPredMap = this.stateToAltSetWithSemanticPredicatesMap.get(d);
        if (altToPredMap == null) {
            return null;
        }
        return altToPredMap.get(Utils.integer(alt));
    }

    public boolean hasPredicate() {
        return this.stateToAltSetWithSemanticPredicatesMap.size() > 0;
    }

    public Set getNondeterministicStatesResolvedWithSemanticPredicate() {
        return this.statesResolvedWithSemanticPredicatesSet;
    }

    public Map<Integer, Set<Token>> getIncompletelyCoveredAlts(DFAState d) {
        return this.stateToIncompletelyCoveredAltsMap.get(d);
    }

    public void issueWarnings() {
        List<Integer> unreachableAlts;
        Set danglingStates;
        if (this.nonLLStarDecision && !this.dfa.getAutoBacktrackMode()) {
            ErrorManager.nonLLStarDecision(this);
        }
        this.issueRecursionWarnings();
        Set resolvedStates = this.getNondeterministicStatesResolvedWithSemanticPredicate();
        Set problemStates = this.getDFAStatesWithSyntacticallyAmbiguousAlts();
        if (problemStates.size() > 0) {
            Iterator it = problemStates.iterator();
            while (it.hasNext() && !this.dfa.nfa.grammar.NFAToDFAConversionExternallyAborted()) {
                String greedyS;
                DFAState d = (DFAState)it.next();
                Map<Integer, Set<Token>> insufficientAltToLocations = this.getIncompletelyCoveredAlts(d);
                if (insufficientAltToLocations != null && insufficientAltToLocations.size() > 0) {
                    ErrorManager.insufficientPredicates(this, d, insufficientAltToLocations);
                }
                if (resolvedStates != null && resolvedStates.contains(d)) continue;
                Set disabledAlts = this.getDisabledAlternatives(d);
                this.stripWildCardAlts(disabledAlts);
                if (disabledAlts.size() <= 0) continue;
                boolean explicitlyGreedy = false;
                GrammarAST blockAST = d.dfa.nfa.grammar.getDecisionBlockAST(d.dfa.decisionNumber);
                if (blockAST != null && (greedyS = (String)blockAST.getBlockOption("greedy")) != null && greedyS.equals("true")) {
                    explicitlyGreedy = true;
                }
                if (explicitlyGreedy) continue;
                ErrorManager.nondeterminism(this, d);
            }
        }
        if ((danglingStates = this.getDanglingStates()).size() > 0) {
            for (DFAState d : danglingStates) {
                ErrorManager.danglingState(this, d);
            }
        }
        if (!this.nonLLStarDecision && (unreachableAlts = this.dfa.getUnreachableAlts()) != null && unreachableAlts.size() > 0) {
            boolean isInheritedTokensRule = false;
            if (this.dfa.isTokensRuleDecision()) {
                for (Integer altI : unreachableAlts) {
                    GrammarAST decAST = this.dfa.getDecisionASTNode();
                    GrammarAST altAST = decAST.getChild(altI - 1);
                    GrammarAST delegatedTokensAlt = altAST.getFirstChildWithType(39);
                    if (delegatedTokensAlt == null) continue;
                    isInheritedTokensRule = true;
                    ErrorManager.grammarWarning(162, this.dfa.nfa.grammar, null, this.dfa.nfa.grammar.name, delegatedTokensAlt.getFirstChild().getText());
                }
            }
            if (!isInheritedTokensRule) {
                ErrorManager.unreachableAlts(this, unreachableAlts);
            }
        }
    }

    protected void stripWildCardAlts(Set disabledAlts) {
        ArrayList sortedDisableAlts = new ArrayList(disabledAlts);
        Collections.sort(sortedDisableAlts);
        Integer lastAlt = (Integer)sortedDisableAlts.get(sortedDisableAlts.size() - 1);
        GrammarAST blockAST = this.dfa.nfa.grammar.getDecisionBlockAST(this.dfa.decisionNumber);
        GrammarAST lastAltAST = null;
        lastAltAST = blockAST.getChild(0).getType() == 4 ? blockAST.getChild(lastAlt) : blockAST.getChild(lastAlt - 1);
        if (lastAltAST.getType() != 19 && lastAltAST.getChild(0).getType() == 72 && lastAltAST.getChild(1).getType() == 20) {
            disabledAlts.remove(lastAlt);
        }
    }

    protected void issueRecursionWarnings() {
        Set dfaStatesWithRecursionProblems = this.stateToRecursionOverflowConfigurationsMap.keySet();
        HashMap altToTargetToCallSitesMap = new HashMap();
        HashMap altToDFAState = new HashMap();
        this.computeAltToProblemMaps(dfaStatesWithRecursionProblems, this.stateToRecursionOverflowConfigurationsMap, altToTargetToCallSitesMap, altToDFAState);
        Set alts = altToTargetToCallSitesMap.keySet();
        ArrayList sortedAlts = new ArrayList(alts);
        Collections.sort(sortedAlts);
        for (Integer altI : sortedAlts) {
            Map targetToCallSiteMap = (Map)altToTargetToCallSitesMap.get(altI);
            Set targetRules = targetToCallSiteMap.keySet();
            Collection callSiteStates = targetToCallSiteMap.values();
            DFAState sampleBadState = (DFAState)altToDFAState.get(altI);
            ErrorManager.recursionOverflow(this, sampleBadState, altI, targetRules, callSiteStates);
        }
    }

    private void computeAltToProblemMaps(Set dfaStatesUnaliased, Map configurationsMap, Map altToTargetToCallSitesMap, Map altToDFAState) {
        for (Integer stateI : dfaStatesUnaliased) {
            List configs = (List)configurationsMap.get(stateI);
            for (int i = 0; i < configs.size(); ++i) {
                HashSet<NFAState> callSites;
                NFAConfiguration c = (NFAConfiguration)configs.get(i);
                NFAState ruleInvocationState = this.dfa.nfa.getState(c.state);
                Transition transition0 = ruleInvocationState.transition[0];
                RuleClosureTransition ref = (RuleClosureTransition)transition0;
                String targetRule = ((NFAState)ref.target).enclosingRule.name;
                Integer altI = Utils.integer(c.alt);
                HashMap<String, HashSet<NFAState>> targetToCallSiteMap = (HashMap<String, HashSet<NFAState>>)altToTargetToCallSitesMap.get(altI);
                if (targetToCallSiteMap == null) {
                    targetToCallSiteMap = new HashMap<String, HashSet<NFAState>>();
                    altToTargetToCallSitesMap.put(altI, targetToCallSiteMap);
                }
                if ((callSites = (HashSet<NFAState>)targetToCallSiteMap.get(targetRule)) == null) {
                    callSites = new HashSet<NFAState>();
                    targetToCallSiteMap.put(targetRule, callSites);
                }
                callSites.add(ruleInvocationState);
                if (altToDFAState.get(altI) != null) continue;
                DFAState sampleBadState = this.dfa.getState(stateI);
                altToDFAState.put(altI, sampleBadState);
            }
        }
    }

    private Set getUnaliasedDFAStateSet(Set dfaStatesWithRecursionProblems) {
        HashSet<Integer> dfaStatesUnaliased = new HashSet<Integer>();
        for (Integer stateI : dfaStatesWithRecursionProblems) {
            DFAState d = this.dfa.getState(stateI);
            dfaStatesUnaliased.add(Utils.integer(d.stateNumber));
        }
        return dfaStatesUnaliased;
    }

    public void reportDanglingState(DFAState d) {
        this.danglingStates.add(d);
    }

    public void reportNonLLStarDecision(DFA dfa) {
        this.nonLLStarDecision = true;
        ++dfa.nfa.grammar.numNonLLStar;
        this.altsWithProblem.addAll(dfa.recursiveAltSet.toList());
    }

    public void reportRecursionOverflow(DFAState d, NFAConfiguration recursionNFAConfiguration) {
        if (d.stateNumber > 0) {
            Integer stateI = Utils.integer(d.stateNumber);
            this.stateToRecursionOverflowConfigurationsMap.map(stateI, recursionNFAConfiguration);
        }
    }

    public void reportNondeterminism(DFAState d, Set<Integer> nondeterministicAlts) {
        this.altsWithProblem.addAll(nondeterministicAlts);
        this.statesWithSyntacticallyAmbiguousAltsSet.add(d);
        this.dfa.nfa.grammar.setOfNondeterministicDecisionNumbers.add(Utils.integer(this.dfa.getDecisionNumber()));
    }

    public void reportLexerRuleNondeterminism(DFAState d, Set<Integer> nondeterministicAlts) {
        this.stateToSyntacticallyAmbiguousTokensRuleAltsMap.put(d, nondeterministicAlts);
    }

    public void reportNondeterminismResolvedWithSemanticPredicate(DFAState d) {
        if (d.abortedDueToRecursionOverflow) {
            d.dfa.probe.removeRecursiveOverflowState(d);
        }
        this.statesResolvedWithSemanticPredicatesSet.add(d);
        this.dfa.nfa.grammar.setOfNondeterministicDecisionNumbersResolvedWithPredicates.add(Utils.integer(this.dfa.getDecisionNumber()));
    }

    public void reportAltPredicateContext(DFAState d, Map altPredicateContext) {
        HashMap copy = new HashMap();
        copy.putAll(altPredicateContext);
        this.stateToAltSetWithSemanticPredicatesMap.put(d, copy);
    }

    public void reportIncompletelyCoveredAlts(DFAState d, Map<Integer, Set<Token>> altToLocationsReachableWithoutPredicate) {
        this.stateToIncompletelyCoveredAltsMap.put(d, altToLocationsReachableWithoutPredicate);
    }

    protected boolean reachesState(DFAState startState, DFAState targetState, Set states) {
        if (startState == targetState) {
            states.add(targetState);
            this.stateReachable.put(startState.stateNumber, REACHABLE_YES);
            return true;
        }
        DFAState s = startState;
        this.stateReachable.put(s.stateNumber, REACHABLE_BUSY);
        for (int i = 0; i < s.getNumberOfTransitions(); ++i) {
            Transition t = s.transition(i);
            DFAState edgeTarget = (DFAState)t.target;
            Integer targetStatus = this.stateReachable.get(edgeTarget.stateNumber);
            if (targetStatus == REACHABLE_BUSY) continue;
            if (targetStatus == REACHABLE_YES) {
                this.stateReachable.put(s.stateNumber, REACHABLE_YES);
                return true;
            }
            if (targetStatus == REACHABLE_NO || !this.reachesState(edgeTarget, targetState, states)) continue;
            states.add(s);
            this.stateReachable.put(s.stateNumber, REACHABLE_YES);
            return true;
        }
        this.stateReachable.put(s.stateNumber, REACHABLE_NO);
        return false;
    }

    protected Set getDFAPathStatesToTarget(DFAState targetState) {
        HashSet dfaStates = new HashSet();
        this.stateReachable = new HashMap<Integer, Integer>();
        if (this.dfa == null || this.dfa.startState == null) {
            return dfaStates;
        }
        boolean reaches = this.reachesState(this.dfa.startState, targetState, dfaStates);
        return dfaStates;
    }

    protected void getSampleInputSequenceUsingStateSet(State startState, State targetState, Set states, List<Label> labels) {
        this.statesVisitedDuringSampleSequence.add(startState.stateNumber);
        for (int i = 0; i < startState.getNumberOfTransitions(); ++i) {
            Transition t = startState.transition(i);
            DFAState edgeTarget = (DFAState)t.target;
            if (!states.contains(edgeTarget) || this.statesVisitedDuringSampleSequence.contains(edgeTarget.stateNumber)) continue;
            labels.add(t.label);
            if (edgeTarget != targetState) {
                this.getSampleInputSequenceUsingStateSet(edgeTarget, targetState, states, labels);
            }
            return;
        }
        labels.add(new Label(-5));
    }

    protected boolean getNFAPath(NFAState s, int labelIndex, List labels, List path) {
        String thisStateKey = this.getStateLabelIndexKey(s.stateNumber, labelIndex);
        if (this.statesVisitedAtInputDepth.contains(thisStateKey)) {
            return false;
        }
        this.statesVisitedAtInputDepth.add(thisStateKey);
        for (int i = 0; i < s.getNumberOfTransitions(); ++i) {
            boolean found;
            Transition t = s.transition[i];
            NFAState edgeTarget = (NFAState)t.target;
            Label label = (Label)labels.get(labelIndex);
            if (t.label.isEpsilon() || t.label.isSemanticPredicate()) {
                path.add(edgeTarget);
                found = this.getNFAPath(edgeTarget, labelIndex, labels, path);
                if (found) {
                    this.statesVisitedAtInputDepth.remove(thisStateKey);
                    return true;
                }
                path.remove(path.size() - 1);
                continue;
            }
            if (!t.label.matches(label)) continue;
            path.add(edgeTarget);
            if (labelIndex == labels.size() - 1) {
                this.statesVisitedAtInputDepth.remove(thisStateKey);
                return true;
            }
            found = this.getNFAPath(edgeTarget, labelIndex + 1, labels, path);
            if (found) {
                this.statesVisitedAtInputDepth.remove(thisStateKey);
                return true;
            }
            path.remove(path.size() - 1);
        }
        this.statesVisitedAtInputDepth.remove(thisStateKey);
        return false;
    }

    protected String getStateLabelIndexKey(int s, int i) {
        StringBuffer buf = new StringBuffer();
        buf.append(s);
        buf.append('_');
        buf.append(i);
        return buf.toString();
    }

    public String getTokenNameForTokensRuleAlt(int alt) {
        NFAState decisionState = this.dfa.getNFADecisionStartState();
        NFAState altState = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(decisionState, alt);
        NFAState decisionLeft = (NFAState)altState.transition[0].target;
        RuleClosureTransition ruleCallEdge = (RuleClosureTransition)decisionLeft.transition[0];
        NFAState ruleStartState = (NFAState)ruleCallEdge.target;
        return ruleStartState.enclosingRule.name;
    }

    public void reset() {
        this.stateToRecursionOverflowConfigurationsMap.clear();
    }
}

