% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imperfect_competition.R
\name{monopoly_solver}
\alias{monopoly_solver}
\title{Monopoly Profit Maximization}
\usage{
monopoly_solver(c0 = 0, c1 = 1, c2 = 0, p0 = 0, p1 = -1,
  p2 = 0, q0 = 0)
}
\arguments{
\item{c0}{intercept of monopolist's cost function. Defaults to 0.}

\item{c1}{linear term's parameter of monopolist's cost function. Defaults to 1.}

\item{c2}{quadratic terms's parameter of the monopolist's cost function. Defaults to 0.}

\item{p0}{intercept of inverse demand function. Defaults to 0.}

\item{p1}{linear term's parameter of inverse demand function. Defaults to -1. Note that it is important to specify it as a negative number, or the demand curve will be upward sloping.}

\item{p2}{quadratic terms's parameter of the demand curve. Defaults to 0.}

\item{q0}{Initial guess for monopolist's output. Defaults to 0. Strongly advise not to set this parameter unless you are very aware of what you're doing.}
}
\value{
A list with market price, output, profits, markup, profitrate.
}
\description{
This function numerically finds the profit-maximizing output for a monopolist with linear and non-linear cost and demand curves. For guaranteed existence of feasible solution (in which both price and output are positive), a linear demand curve might be necessary.
}
\examples{

monopoly_solver(c0 = 20, p0 = 50 )

}
\author{
Pedro Cavalcante Oliveira, Department of Economics, Fluminense Federal University
}
