% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/P_chisq.test.R
\name{P_chisq.test}
\alias{P_chisq.test}
\title{Chi-Square test on record probabilities}
\usage{
P_chisq.test(XM_T, record = c("upper", "lower"), correction = TRUE)
}
\arguments{
\item{XM_T}{A matrix.}

\item{record}{A character string indicating the type of record to be 
calculated,  "upper" or "lower".}

\item{correction}{Logical flag. If \code{TRUE}, a generalization of the 
record indicator random variables is calculated by making all expected 
values greater than 5.}
}
\value{
A  \code{"htest"} object  with elements:
  \item{statistic}{Value of the chi-squared statistic.}
  \item{df}{Degrees of freedom of the approximate chi-squared.}
  \item{p.value}{P-value.}
  \item{method}{A character string indicating the type of test performed.}
  \item{data.name}{A character string giving the name of the data.}
}
\description{
This function performs a chi-square test based on the record 
  probabiliteis \eqn{p_t} to study the hypothesis of the classical record 
  model.
}
\details{
The null hypothesis of this chi-square test is that in all the 
  vectors (columns of matrix \code{XM_T}), the probability of record at 
  time \eqn{t} is \eqn{1/t}, and the alternative that the probabilities 
  are not equal to those values. First, the chi-square goodness of fit
  statistics to study the  null hypotehsis \eqn{H_0:\,p_t = 1/t} are 
  calculated for each time \eqn{t=2,\ldots,T}, where the observed value 
  is the number of records  at time \eqn{t} in the \eqn{M} vectors and the
  expected value under the null is \eqn{M/t}. The test statistic is the sum
  of the previous \eqn{T-1} statistics and its distribution under the null 
  is approximately \eqn{\chi^2_{T-1}}.

  The chi-square approximation may not be valid with low \eqn{M}, since it
  requires expected values \eqn{> 5} or up to 20 \% of the expected values
  is between 1 and 5. If this condition is not satisfied, a warning is 
  displayed. In order to avoid this problem, a \code{correction} can be 
  made.
}
\examples{
P_chisq.test(ZaragozaSeries)
P_chisq.test(ZaragozaSeries, correction = FALSE)
}
\seealso{
\code{\link{P_exactPB.test}}, \code{\link{P_regression.test}}
}
\author{
Jorge Castillo-Mateo
}
