% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L.plot.R
\name{L.plot}
\alias{L.plot}
\title{Times of Record Plot}
\usage{
L.plot(
  X,
  all = TRUE,
  record = c("upper", "lower"),
  point.col = "gray23",
  point.alpha = 0.8,
  line.col = "gray95"
)
}
\arguments{
\item{X}{A numeric vector, matrix (or data frame).}

\item{all}{Logical. If \code{TRUE} (the default) the four types of record
are displayed.}

\item{record}{If \code{all = FALSE}, a character string indicating the type
of record to be calculated, "upper" or "lower".}

\item{point.col, point.alpha}{Color and transparency of the points.}

\item{line.col}{Color to plot lines.}
}
\value{
A ggplot object.
}
\description{
This function builds a ggplot object to display the upper 
  and lower record times for both forward and backward directions.
}
\details{
The function can be applied to plot the record times in a vector 
  (if argument \code{X} is a vector) or to plot and compare the record 
  times in a set of vectors (if argument \code{X} is a matrix). In the 
  latter case, the approach to obtain the record times is applied to each 
  column of the matrix.
  
  If \code{all = TRUE}, a matrix of four panels is displayed for upper and
  lower records, and for the forward and backward (\code{\link{series_rev}})
  directions. Otherwise, only one type of forward record is displayed.
  
  An example of use of a plot with similar ideas is shown in Benestad 
  (2004, Figures 3 and 8).
}
\examples{
Y <- c(1, 5, 3, 6, 6, 9, 2, 11, 17, 8)
L.plot(Y, all = FALSE)

L.plot(ZaragozaSeries, point.col = 1)

}
\references{
Benestad RE (2004). “Record-Values, Nonstationarity Tests and Extreme Value Distributions.”
\emph{Global and Planetary Change}, \strong{44}(1-4), 11-26.
}
\seealso{
\code{\link{L.record}}
}
\author{
Jorge Castillo-Mateo
}
