% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_regCombin.R
\name{summary_regCombin}
\alias{summary_regCombin}
\title{Produce the final summary table for the output of the felogit function}
\usage{
summary_regCombin(output, format = NULL)
}
\arguments{
\item{output}{the output of the felogit function}

\item{format}{can take value "latex" to print the latex table}
}
\value{
a kableExtra or xtable table plotted respectively in the R viewer or terminal
}
\description{
Produce the final summary table for the output of the felogit function
}
\examples{

### Simulating according to this DGP
n=200
Xnc_x = rnorm(n,0,1.5)
Xnc_y = rnorm(n,0,1.5)
epsilon = rnorm(n,0,1)

## true value
beta0 =1
Y = Xnc_y*beta0 + epsilon
out_var = "Y"
nc_var = "Xnc"

# create the datasets
Ldata<- as.data.frame(Y)
colnames(Ldata) <- c(out_var)
Rdata <- as.data.frame(Xnc_x)
colnames(Rdata) <- c(nc_var)


############# Estimation #############
output <- regCombin(Ldata,Rdata,out_var,nc_var)
mat = summary_regCombin(output)
}
