% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rga.R
\name{rga}
\alias{rga}
\title{Reliability Growth Analysis.}
\usage{
rga(
  times,
  failures,
  model_type = "Crow-AMSAA",
  breakpoints = NULL,
  conf_level = 0.95
)
}
\arguments{
\item{times}{A vector of cumulative times at which failures occurred.}

\item{failures}{A vector of the number of failures at each corresponding time in times.}

\item{model_type}{The model type. Either \code{Crow-AMSAA} (default) or \verb{Piecewise Weibull NHPP} with change point detection.}

\item{breakpoints}{An optional vector of breakpoints for the \verb{Piecewise Weibull NHPP} model.}

\item{conf_level}{The desired confidence level, which defaults to 95\%.}
}
\value{
The function returns an object of class \code{rga} that contains the results for the model.
}
\description{
Reliability Growth Analysis.
}
\examples{
times <- c(100, 200, 300, 400, 500)
failures <- c(1, 2, 1, 3, 2)
result <- rga(times, failures)
print(result)
}
