% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start_matrix.R
\name{start_matrix}
\alias{start_matrix}
\title{Setup of the start matrix}
\usage{
start_matrix(p, k)
}
\arguments{
\item{p}{Marginal probabilities of the start matrix.}

\item{k}{Number of rows to be generated.}
}
\value{
A (k x p)-Matrix with with entries 0 and 1 according to
  the specified marginal probabilities p.
}
\description{
Generation of the start matrix with n rows and specified marginal
probabilities p.
}
\details{
The start matrix needs to be setup for further use in the genetic
algorithm implemented in the function \code{\link{iter_matrix}}. For
high-dimensional cases or if the marginal probabilities have
multiple decimal places, the number k of rows should be large (up
to multiple thousand).
}
\examples{
X0 <- start_matrix(p = c(0.5, 0.6), k = 10000)

## check if p can be restored
apply(X0, 2, mean)
}
\references{
Kruppa, J., Lepenies, B., & Jung, K. (2018). A genetic algorithm for simulating correlated binary data from biomedical research. \emph{Computers in biology and medicine}, \strong{92}, 1-8. \doi{10.1016/j.compbiomed.2017.10.023}
}
\author{
Jochen Kruppa, Klaus Jung
}
