% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levelSceptical.R
\name{levelSceptical}
\alias{levelSceptical}
\title{Computes the level for the sceptical p-value}
\usage{
levelSceptical(
  level,
  alternative = c("one.sided", "two.sided"),
  type = c("golden", "nominal", "liberal", "controlled")
)
}
\arguments{
\item{level}{Numeric vector of required replication success levels.}

\item{alternative}{Either "one.sided" (default) or "two.sided".
Specifies if the replication success level is one-sided or two-sided. If the replication success level is one-sided,
then a one-sided level for the sceptical p-value is computed.}

\item{type}{The calibration type can be either "golden" (default), "nominal", "liberal", or "controlled".
\code{type} = "golden" ensures that for an original study just significant at the specified \code{level},
replication success is only possible if the replication effect estimate is larger than the original one.
If \code{type =} "controlled", the type-I error rate is equal to \code{level}^2 (for \code{alternative} ="two.sided") or
2 \eqn{\times}{*}\code{level}^2 (for \code{alternative} = "one.sided") if the variance ratio is equal to 1.
The type \code{"nominal"} ensures that the type-I error rate is always smaller
than \code{level}^2. Significance of both the original and replication study
at \code{level} is then a necessary but not sufficient requirement for replication success.
If \code{type} is "liberal" then significance of both studies is a
sufficient requirement for replication success if the variance ratio is equal to 1.}
}
\value{
Levels for the sceptical p-value.
}
\description{
The level for the sceptical p-value is computed based on the specified
alternative and calibration type.
}
\examples{
levelSceptical(level = 0.025, alternative = "one.sided", type = "nominal")
levelSceptical(level = 0.025, alternative = "one.sided", type = "liberal")
levelSceptical(level = 0.025, alternative = "one.sided", type = "controlled")
levelSceptical(level = 0.025, alternative = "one.sided", type = "golden")
}
\references{
Held, L. (2020). A new standard for the analysis and design of replication studies (with discussion).
\emph{Journal of the Royal Statistical Society: Series A (Statistics in Society)}, \bold{183}, 431-448.
\doi{10.1111/rssa.12493}

Held, L. (2020). The harmonic mean chi-squared test to substantiate scientific findings.
\emph{Journal of the Royal Statistical Society: Series C (Applied Statistics)}, \bold{69}, 697-708.
\doi{10.1111/rssc.12410}

Held, L., Micheloud, C., Pawel, S. (2021). The assessment of replication
success based on relative effect size. \url{https://arxiv.org/abs/2009.07782}
}
\author{
Leonhard Held
}
