% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBed.R
\name{plotBed}
\alias{plotBed}
\title{A function to boxplot 'score' column of a BED dataframe,
per unique chromosome name in the ‘chrom’ column. The resulting plot also highlights outliers
based on the inter quartile range (IQR). The genome wide median is plotted as a pink line through the boxplots.}
\usage{
plotBed(bed, plotting = TRUE)
}
\arguments{
\item{bed}{A dataframe containing 'score' and 'chrom' columns (dataframe).}

\item{plotting}{Should the plot object be sent to the default device? (boolean, defaults to TRUE).}
}
\description{
A function to boxplot 'score' column of a BED dataframe,
per unique chromosome name in the ‘chrom’ column. The resulting plot also highlights outliers
based on the inter quartile range (IQR). The genome wide median is plotted as a pink line through the boxplots.
}
\examples{
plotBed(W303_S)
plotObject <- plotBed(W303_G2,plotting=FALSE)
}
\keyword{BED}
\keyword{bioinformatics}
\keyword{boxplot}
\keyword{genomics}
