/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.html4r.tools;

import java.util.Iterator;
import java.util.LinkedHashMap;
public class Format {
	
	public static String getJSString( LinkedHashMap<String, String> properties ){
		String out = "";
		for (Iterator<String> it1 = properties.keySet().iterator(); it1.hasNext();) {
			String prop = it1.next();
			out += prop + ":" + properties.get(prop) + ";";
		}
		return out;
	}
	
	public static LinkedHashMap<String, String> getCellProperties(String borderBottomColor, String borderBottomStyle, int borderBottomWidth
			, String borderLeftColor, String borderLeftStyle, int borderLeftWidth
			, String borderTopColor, String borderTopStyle, int borderTopWidth
			, String borderRightColor, String borderRightStyle, int borderRightWidth, 
			String verticalAlign, int paddingBottom, int paddingTop, int paddingLeft, int paddingRight
			, String backgroundColor
			)  {
		LinkedHashMap<String, String> tcPr = new LinkedHashMap<String, String>();

		tcPr.put("background-color", backgroundColor);	

		tcPr.put("border-bottom-color", borderBottomColor );	
		tcPr.put("border-bottom-style", borderBottomStyle );	
		tcPr.put("border-bottom-width", borderBottomWidth + "px" );	
		tcPr.put("border-top-color", borderTopColor );	
		tcPr.put("border-top-style", borderTopStyle );	
		tcPr.put("border-top-width", borderTopWidth + "px" );	
		tcPr.put("border-right-color", borderRightColor );	
		tcPr.put("border-right-style", borderRightStyle );	
		tcPr.put("border-right-width", borderRightWidth + "px" );	
		tcPr.put("border-left-color", borderLeftColor );	
		tcPr.put("border-left-style", borderLeftStyle );	
		tcPr.put("border-left-width", borderLeftWidth + "px" );	

		if( verticalAlign.equals("center") )
			tcPr.put("vertical-align", "middle" );	
		else tcPr.put("vertical-align", verticalAlign );	
		
	
		tcPr.put("padding-left", paddingLeft + "px" );	
		tcPr.put("padding-right", paddingRight + "px" );	
		tcPr.put("padding-top", paddingTop + "px" );	
		tcPr.put("padding-bottom", paddingBottom + "px" );	

	    return tcPr;
	}
	


}
