% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/addParagraph.docx.R
\name{addParagraph.docx}
\alias{addParagraph.docx}
\title{Insert a paragraph into a docx object}
\usage{
\method{addParagraph}{docx}(doc, value, stylename, bookmark,
  par.properties = parProperties(), restart.numbering = FALSE, ...)
}
\arguments{
\item{doc}{Object of class \code{\link{docx}} where paragraph has to be added}

\item{value}{text to add to the document as paragraphs:
an object of class \code{\link{pot}} or \code{\link{set_of_paragraphs}}
or a character vector.}

\item{stylename}{value of the named style to apply to paragraphs in the docx document.
Expected value is an existing stylename of the template document used to create the
\code{docx} object. see \code{\link{styles.docx}}.}

\item{bookmark}{a character value ; id of the Word bookmark to
replace by the table. optional. See \code{\link{bookmark}}.}

\item{par.properties}{\code{\link{parProperties}} to apply to paragraphs, only used
if \code{stylename} if missing.}

\item{restart.numbering}{boolean value. If \code{TRUE}, next numbered
list counter will be set to 1.}

\item{...}{further arguments, not used.}
}
\value{
an object of class \code{\link{docx}}.
}
\description{
Insert paragraph(s) of text into a \code{docx} object
}
\examples{
\dontrun{
doc.filename = "addParagraph_example.docx"

# set default font size to 10
options( "ReporteRs-fontsize" = 10 )

doc = docx( )

# returns available stylenames
styles( doc )

doc = addTitle( doc, "Title example 1", level = 1 )

# Add "Hello World" into the document doc
doc = addParagraph(doc, "Hello Word", stylename = "Normal" )


doc = addTitle( doc, "Title example 2", level = 1 )

# define some text
sometext = c( "Lorem ipsum dolor sit amet, consectetur adipiscing elit.", 
"In sit amet ipsum tellus. Vivamus dignissim arcu sit amet faucibus auctor.", 
"Quisque dictum tristique ligula.")

# add sometext with stylename BulletList
doc = addParagraph( doc, value = sometext, stylename="BulletList" )


doc = addTitle( doc, "Title example 3", level = 1 )

# "My tailor is rich" with formatting on some words
pot1 = pot("My tailor", textProperties(color = "red" ) 
  ) + " is " + pot("rich", textProperties(shading.color = "red", 
  font.weight = "bold" ) )

# "Cats and dogs" with formatting on some words
pot2 = pot("Cats", textProperties(color = "red" ) ) + 
  " and " + 
  pot("dogs", textProperties( color = "blue" ), 
    hyperlink = "http://www.wikipedia.org/" )

# create a set of paragraphs made of pot1 and pot2
my.pars = set_of_paragraphs( pot1, pot2 )

# Add my.pars into the document doc
doc = addParagraph(doc, my.pars, stylename = "Normal" )


doc = addTitle( doc, "Title example 4", level = 1 )
# define some text
text1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit."
text2 = "In sit amet ipsum tellus. Vivamus arcu sit amet faucibus auctor."
text3 = "Quisque dictum tristique ligula."

# define parProperties with list properties
ordered.list.level1 = parProperties(list.style = "ordered", 
	level = 1 )
ordered.list.level2 = parProperties(list.style = "ordered", 
	level = 2 )

# define parProperties with list properties
unordered.list.level1 = parProperties(list.style = "unordered", 
	level = 1 )
unordered.list.level2 = parProperties(list.style = "unordered", 
	level = 2 )

# add ordered list items 
doc = addParagraph( doc, value = text1, 
	par.properties = ordered.list.level1 )
doc = addParagraph( doc, value = text2, 
	par.properties = ordered.list.level2 )

# add ordered list items without restart renumbering
doc = addParagraph( doc, value = c( text1, text2, text3), 
	par.properties = ordered.list.level1 )

# add ordered list items and restart renumbering
doc = addParagraph( doc, value = c( text1, text2, text3), 
restart.numbering = TRUE, par.properties = ordered.list.level1 )

# add unordered list items
doc = addParagraph( doc, value = text1, 
	par.properties = unordered.list.level1 )
doc = addParagraph( doc, value = text2, 
	par.properties = unordered.list.level2 )


# Write the object
writeDoc( doc, file = doc.filename )
}
}
\seealso{
\code{\link{docx}}, \code{\link{addParagraph}},
\code{\link{bookmark}}, \code{\link{addMarkdown.docx}},
\code{\link{pot}}
}

