% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addSubtitle.R
\name{addSubtitle}
\alias{addSubtitle}
\alias{addSubtitle.pptx}
\title{Add a subtitle shape into a document object}
\usage{
addSubtitle(doc, ...)

\method{addSubtitle}{pptx}(doc, value, ...)
}
\arguments{
\item{doc}{document object}

\item{...}{further arguments passed to other methods}

\item{value}{\code{"character"} value to use as subtitle text}
}
\value{
a document object
}
\description{
Add a subtitle shape into a document object

Add a addSubtitle shape into a \code{\link{pptx}} object.
}
\details{
Subtitle shape only exist in slide of type 'Title Slide'.
}
\examples{
\donttest{
doc.filename = "addSubtitle_example.pptx"
doc <- pptx()
doc <- addSlide( doc, slide.layout = "Title Slide" )
#set the main title
doc <- addTitle( doc, "Presentation title" )
#set the sub-title
doc <- addSubtitle( doc , "This document is generated with ReporteRs.")
writeDoc( doc, file = doc.filename )
}
}
\seealso{
\code{\link{pptx}}
}
