/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.img;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.List;

import org.docx4j.XmlUtils;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.PPTX4R;
import org.pptx4j.pml.GroupShape;

public class DrawingML extends DocComponent implements PPTX4R{
	private String filename;
	private int width, height;
	
	
	public boolean validateDOCXComponent(){
		if( getPPr() == null ) {
			return false;
		} else if( getCx() < 0 ) {
			return false;
		} else if( getCy() < 0 ) {
			return false;
		}
		
		return true;
	}
	
	public DrawingML(String filename){
		this.filename=filename;
	}
	
	public void setWidth(int w){
		width = w;
	}
	public void setHeight(int h){
		height = h;
	}
	
	public int getWidth(){
		return width;
	}
	public int getHeight(){
		return height;
	}
	
	public P get_docx_elt() throws Exception{
		
		String sCurrentLine;
		String data="";
		if( !validateDOCXComponent() ) throw new Exception("class DrawingML: elements need to be set...");
		BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filename), "UTF-8"));
		
		while ((sCurrentLine = br.readLine()) != null) {
			data = data + sCurrentLine;
		}
		br.close();
        
        Drawing o = (Drawing) XmlUtils.unmarshalString(data, org.docx4j.jaxb.Context.jc, Drawing.class);

        P p = new P();

        R r = new R();
        r.getContent().add(o);
        p.getContent().add(r);
        
		addBookmark(p);
		
        p.setPPr(getPPr());
		return p;
	}
	
	public List<Object> get_pptx_elt() throws Exception{

		String sCurrentLine;
		String data="";
		if( !validatePPTXComponent() ) throw new Exception("class DrawingML: elements need to be set...");
		BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filename), "UTF-8"));

		while ((sCurrentLine = br.readLine()) != null) {
			data = data + sCurrentLine;
		}
		br.close();
		GroupShape gs = (GroupShape)org.docx4j.XmlUtils.unmarshalString(data, org.pptx4j.jaxb.Context.jcPML, GroupShape.class) ;
        return gs.getSpOrGrpSpOrGraphicFrame();
	}
	
}
