/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.sequence;

import com.topologi.diffx.event.CloseElementEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.OpenElementEvent;
import com.topologi.diffx.sequence.EventSequence;
import java.util.Stack;

public final class EventSequenceUtils {
    private EventSequenceUtils() {
    }

    public static boolean isWellFormed(EventSequence sequence) {
        if (sequence == null) {
            return false;
        }
        Stack<DiffXEvent> open = new Stack<DiffXEvent>();
        DiffXEvent e = null;
        for (int i = 0; i < sequence.size(); ++i) {
            e = sequence.getEvent(i);
            if (e instanceof OpenElementEvent) {
                open.push(e);
                continue;
            }
            if (!(e instanceof CloseElementEvent)) continue;
            if (open.empty()) {
                return false;
            }
            OpenElementEvent o = (OpenElementEvent)open.peek();
            String lastOpenElementName = o.getName();
            String closeElementName = ((CloseElementEvent)e).getName();
            if (closeElementName.equals(lastOpenElementName)) continue;
            return false;
        }
        return open.empty();
    }

    public static int getMaxDepth(EventSequence sequence) {
        int max = 0;
        int depth = 0;
        for (int i = 0; i < sequence.size(); ++i) {
            if (sequence.getEvent(i) instanceof OpenElementEvent) {
                ++depth;
            } else if (sequence.getEvent(i) instanceof CloseElementEvent) {
                --depth;
            }
            if (depth <= max) continue;
            max = depth;
        }
        return max;
    }

    public static int getMaxElementContent(EventSequence sequence) {
        int max = 0;
        int tmp = 0;
        for (int i = 0; i < sequence.size(); ++i) {
            DiffXEvent e = sequence.getEvent(i);
            if (e instanceof OpenElementEvent) {
                tmp = 0;
                continue;
            }
            if (e instanceof CloseElementEvent) {
                if (tmp <= max) continue;
                max = tmp;
                continue;
            }
            ++tmp;
        }
        return max;
    }
}

