% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculation.R
\name{get_reporter_score}
\alias{get_reporter_score}
\title{Calculate reporter score}
\usage{
get_reporter_score(
  ko_stat,
  type = c("pathway", "module")[1],
  feature = "ko",
  threads = 1,
  modulelist = NULL,
  perm = 4999,
  verbose = TRUE,
  p.adjust.method2 = "BH",
  min_exist_KO = 3,
  max_exist_KO = 600
)
}
\arguments{
\item{ko_stat}{ko_stat result from \code{\link{pvalue2zs}}}

\item{type}{'pathway' or 'module' for default KOlist for microbiome, 'CC', 'MF', 'BP', 'ALL' for default GOlist for homo sapiens. And org in listed in 'https://www.genome.jp/kegg/catalog/org_list.html' such as 'hsa' (if your kodf is come from a specific organism, you should specify type here).}

\item{feature}{one of 'ko', 'gene', 'compound'}

\item{threads}{threads}

\item{modulelist}{NULL or customized modulelist dataframe, must contain 'id','K_num','KOs','Description' columns. Take the `KOlist` as example, use \code{\link{custom_modulelist}}.}

\item{perm}{permutation number, default: 4999}

\item{verbose}{logical}

\item{p.adjust.method2}{p.adjust.method, see \code{\link[stats]{p.adjust}}}

\item{min_exist_KO}{min exist KO number in a pathway (default, 3, when a pathway contains KOs less than 3, there will be no RS)}

\item{max_exist_KO}{max exist KO number in a pathway (default, 600, when a pathway contains KOs more than 600, there will be no RS)}
}
\value{
reporter_res data.frame
}
\description{
Calculate reporter score
}
\examples{
\donttest{
data("KO_abundance_test")
ko_pvalue <- ko.test(KO_abundance, "Group", metadata)
ko_stat <- pvalue2zs(ko_pvalue, mode = "directed")
reporter_s1 <- get_reporter_score(ko_stat, perm = 499)
}
}
