% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculation.R, R/plot.R
\name{RSA_by_cm}
\alias{RSA_by_cm}
\alias{GRSA_by_cm}
\alias{extract_cluster}
\alias{plot_c_means}
\title{Reporter score analysis after C-means clustering}
\usage{
RSA_by_cm(
  kodf,
  group,
  metadata = NULL,
  k_num = NULL,
  filter_var = 0.7,
  verbose = TRUE,
  method = "pearson",
  ...
)

extract_cluster(rsa_cm_res, cluster = 1)

plot_c_means(
  rsa_cm_res,
  filter_membership,
  mode = 1,
  show.clust.cent = TRUE,
  show_num = TRUE,
  ...
)
}
\arguments{
\item{kodf}{KO_abundance table, rowname is ko id (e.g. K00001),colnames is samples.}

\item{group}{The comparison groups (at least two categories) in your data, one column name of metadata when metadata exist or a vector whose length equal to columns number of kodf. And you can use factor levels to change order.}

\item{metadata}{sample information data.frame contains group}

\item{k_num}{if NULL, perform the cm_test_k, else an integer}

\item{filter_var}{see c_means}

\item{verbose}{verbose}

\item{method}{method from \code{\link{reporter_score}}}

\item{...}{additional}

\item{rsa_cm_res}{a cm_res object}

\item{cluster}{integer}

\item{filter_membership}{filter membership 0~1.}

\item{mode}{1~2}

\item{show.clust.cent}{show cluster center?}

\item{show_num}{show number of each cluster?}
}
\value{
rs_by_cm

reporter_score object

ggplot
}
\description{
Reporter score analysis after C-means clustering

Extract one cluster from rs_by_cm object

Plot c_means result
}
\examples{
message("The following example require some time to run:")
\donttest{
if (requireNamespace("e1071") && requireNamespace("factoextra")) {
  data("KO_abundance_test")
  rsa_cm_res <- RSA_by_cm(KO_abundance, "Group2", metadata,
    k_num = 3,
    filter_var = 0.7, method = "pearson", perm = 199
  )
  extract_cluster(rsa_cm_res, cluster = 1)
}
}
}
\seealso{
Other C_means: 
\code{\link{cm_test_k}()}
}
\concept{C_means}
