% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get.scatterpie}
\alias{get.scatterpie}
\title{Clonal pie-chart}
\usage{
get.scatterpie(re.res, txt = FALSE, legend = FALSE)
}
\arguments{
\item{re.res}{output list returned by fit.re().}

\item{txt}{logical (defaults to FALSE). If TRUE, barcode names will be printed on the pies.}

\item{legend}{logical (defaults to FALSE). If TRUE, the legend of the pie-chart will be printed.}
}
\value{
No return value.
}
\description{
Draw a clonal pie-chart of a random-effects reaction network.
}
\details{
This function generates a clonal pie-chart given a previously fitted random-effects model.
In this representation each clone \eqn{k}{k} is identified with a pie whose slices are
lineage-specific and weighted with \eqn{w_k}{w_k}, defined as the difference between the
conditional expectations of the random-effects on duplication and death parameters, that is
\deqn{w_k = E_{u\vert \Delta Y; \hat{\psi}}[u^k_{\alpha_{lin}}] - E_{u\vert \Delta Y; \hat{\psi}}[u^k_{\delta_{lin}}]}{Eu|y;ψ[α_lin] - Eu|y;ψ[β_lin]},
where \eqn{\texttt{lin}}{lin} is a cell lineage.
The diameter of the \eqn{k}{k}-th pie is proportional to the euclidean 2-norm of \eqn{w_k}{w_k}.
Therefore, the larger the diameter, the more the corresponding clone is expanding
into the lineage associated to the largest slice.
}
\examples{
rcts <- c("A->1", "B->1", "C->1", "D->1",
          "A->0", "B->0", "C->0", "D->0",
          "A->B", "A->C", "C->D") ## set of reactions
ctps <- head(LETTERS,4)
nC <- 3 ## number of clones
S <- 10 ## trajectory length
tau <- 1 ## for tau-leaping algorithm
u_1 <- c(.2, .15, .17, .09*5,
         .001, .007, .004, .002,
         .13, .15, .08)
u_2 <- c(.2, .15, .17, .09,
         .001, .007, .004, .002,
         .13, .15, .08)
u_3 <- c(.2, .15, .17*3, .09,
         .001, .007, .004, .002,
         .13, .15, .08)
theta_allcls <- cbind(u_1, u_2, u_3) ## clone-specific parameters
rownames(theta_allcls) <- rcts
s20 <- 1 ## additional noise
Y <- array(data = NA,
           dim = c(S + 1, length(ctps), nC),
           dimnames = list(seq(from = 0, to = S*tau, by = tau),
                           ctps,
                           1:nC)) ## empty array to store simulations
Y0 <- c(100,0,0,0) ## initial state
names(Y0) <- ctps
for (cl in 1:nC) { ## loop over clones
  Y[,,cl] <- get.sim.tl(Yt = Y0,
                        theta = theta_allcls[,cl],
                        S = S,
                        s2 = s20,
                        tau = tau,
                        rct.lst = rcts,
                        verbose = TRUE)
}
null.res <- fit.null(Y = Y,
                     rct.lst = rcts,
                     maxit = 0, ## needs to be increased (>=100) for real applications
                     lmm = 0, ## needs to be increased (>=5) for real applications
) ## null model fitting

re.res <- fit.re(theta_0 = null.res$fit$par,
                 Y = Y,
                 rct.lst = rcts,
                 maxit = 0, ## needs to be increased (>=100) for real applications
                 lmm = 0, ## needs to be increased (>=5) for real applications
                 maxemit = 1 ## needs to be increased (>= 100) for real applications
) ## random-effects model fitting

get.scatterpie(re.res, txt = TRUE)
}
