% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_utest_Rayleigh.R
\name{st.utestR}
\alias{st.utestR}
\title{Test of Uniformity via Rayleigh Statistic on Stiefel Manifold}
\usage{
st.utestR(x, method = c("Original", "Modified"))
}
\arguments{
\item{x}{either an array of size \eqn{(p\times r\times n)} or a list of length \eqn{n} whose elements are \eqn{(p\times r)} matrix on Stiefel manifold.}

\item{method}{\code{"original"} for conventional Rayleigh statistic or \code{"modified"} for better order of error.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
This function is for hypothesis testing on Stiefel manifold \eqn{St(p,r)} whether the given data is uniformly distributed or not. 
We provide two options (original and modified) for Rayleigh-type statistics, which both follow Chi-squared distribution of degrees of 
freedom \eqn{pr}.
}
\examples{
## Test of Uniformity for 100 samples from St(10,5)
#  Data Generation
mydat = st.runif(n=100, p=10, r=5, rtype='list')

#  Run Tests using two methods
st.utestR(mydat, method='original')
st.utestR(mydat, method='modified')

\dontrun{
## empirical Type 1 error using the same setting as above.
niter   = 10000
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  X = st.runif(n=100, p=10, r=5, rtype='list')
  counter[i] = ifelse(st.utestR(X)$p.value < 0.05, 1, 0)
  print(paste0("iteration ",i,"/10000 complete..."))
}

## print the result
print(paste0("* empirical Type 1 error for 'st.utestR': ",round(sum(counter/niter),5)))
}

}
\references{
\insertRef{mardia_directional_1999}{RiemStiefel}
}
