% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap10euclidean.R
\name{wrap.euclidean}
\alias{wrap.euclidean}
\title{Prepare Data on Euclidean Space}
\usage{
wrap.euclidean(input)
}
\arguments{
\item{input}{data vectors to be wrapped as \code{riemdata} class. Following inputs are considered,
\describe{
\item{matrix}{an \eqn{(n \times p)} matrix of row observations.}
\item{list}{a length-\eqn{n} list whose elements are length-\eqn{p} vectors.}
}}
}
\value{
a named \code{riemdata} S3 object containing
\describe{
  \item{data}{a list of \eqn{(p\times 1)} matrices in \eqn{\mathbf{R}^p}.}
  \item{size}{dimension of the ambient space.}
  \item{name}{name of the manifold of interests, \emph{"euclidean"}}
}
}
\description{
Euclidean space \eqn{\mathbf{R}^p} is the most common space for data analysis, 
which can be considered as a Riemannian manifold with flat metric. Since
the space of matrices is isomorphic to Euclidean space after vectorization, 
we consider the inputs as \eqn{p}-dimensional vectors.
}
\examples{
#-------------------------------------------------------------------
#                 Checker for Two Types of Inputs
#
#  Generate 5 observations in R^3 in Matrix and List.
#-------------------------------------------------------------------
## DATA GENERATION
d1 = array(0,c(5,3))
d2 = list()
for (i in 1:5){
  single  = stats::rnorm(3)
  d1[i,]  = single
  d2[[i]] = single
}

## RUN
test1 = wrap.euclidean(d1)
test2 = wrap.euclidean(d2)

}
\concept{wrapper}
