% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_data_from_styles.R
\name{text_data_from_styles}
\alias{text_data_from_styles}
\title{Get text data from styles}
\usage{
text_data_from_styles(design_tibble)
}
\arguments{
\item{design_tibble}{S3 object of class `design_tibble_style` returned by
queering the 'Figma' API for the published styles. Its design tibble should
contain a unique `file_key` (map for each `file_key` if more than one
exist.)}
}
\value{
tibble with text metadata of exported TEXT styles
}
\description{
Get text data from styles
}
\details{
Given a design_tibble with exported styles this function retrieves
all TEXT style type metadata. It uses the GET file nodes API endpoint and
collects all style data.
}
\examples{
\dontrun{
file_key <- "sFHgQh9dL6369o5wrZHmdR"
file_key \%>\%
 get_file_styles() \%>\%
 as_design_tibble() \%>\%
 text_data_from_styles()
}

}
