% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/australia.R
\name{get_timeseries}
\alias{get_timeseries}
\title{Get time series}
\usage{
get_timeseries(
  parameter_type,
  station_number,
  start_date,
  end_date,
  tz,
  return_fields,
  ts_name
)
}
\arguments{
\item{parameter_type}{The water data parameter type (e.g. Water Course
Discharge). See \code{\link{parameters()}} for a full list.}

\item{station_number}{The AWRC station number.}

\item{start_date}{Start date formatted as a string or date class
(YYYY-MM-DD).}

\item{end_date}{End date formatted as a string or date class (YYYY-MM-DD).}

\item{tz}{Optional: the desired time zone for the output timeseries. Input
must be an Olson Name (see \code{OlsonNames()}). By default the timeseries are
returned in non-DST time zones (AEST, ACST or AWST) depending on the
station location.}

\item{return_fields}{Optional: columns to be returned from Water Data Online.
By default Timestamp, Value and Quality Code are returned.}

\item{ts_name}{The timeseries name (e.g. DMQaQc.Merged.DailyMean.24HR) that
is desired.}
}
\value{
A tibble with columns with the requested return_fields. A zero row tibble is
returned if no data is returned  from the query. The columns of the tibble
are returned as character classes and have not been formatted to more
appropriate correct classes (this happens in other functions).
}
\description{
Get timeseries data from Water Data online
}
\details{
This function can be used if you want to retrieve a specific
timeseries that is not the default quality checked one.

Common valid return fields are:
\itemize{
\item Timestamp
\item Value
\item Quality Code
\item Interpolation Type
}

Other valid return fields (depending on the parameter requested) may be:
\itemize{
\item Absolute Value
\item AV Interpolation
\item AV Quality Code
\item Runoff Value
\item RV Interpolation
\item RV Quality Code
\item Aggregation
\item Accuracy
}

If the request is not valid it will fail.
}
\examples{
# Accessible dam storage, as shown on the BoM Water Storage dashboard
\dontrun{
get_timeseries(
  parameter_type = "Storage Volume",
  "G8150011",
  "2020-01-01",
  "2020-01-31",
  ts_name = "PR02AVQaQc.Merged.DailyMean.24HR",
  tz = NULL,
  return_fields = c("Timestamp", "Value", "Quality Code")
)
}
}
