\name{HOMFLYpolynomial}
\alias{HOMFLYpolynomial}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Compute the HOMFLY polynomial of a polygonal link
%%  ~~function to do ... ~~
}
\description{Given the skein tree (generated by \code{skeinIterator}), 
compute the HOMFLY polynomial of the polygonal link.
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
HOMFLYpolynomial(leaves, tree, skein.sign)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
	\item{leaves}{a list containing the binary indices of the 
	tree leaves}
	\item{tree}{a list containing the skein tree as 
	returned by \code{skeinIterator}. }
	\item{skein.sign}{the skein sign to be used (+1 or -1)}
%%     ~~Describe \code{points3D} here~~
%%     ~~Describe \code{ends} here~~
}
\details{The polynomial computation relies on \code{rSymPy}. 
Please notice that the first time sympy is invoked is expected to be 
much slower than subsequent ones. 
%%  ~~ If necessary, more details than the description above ~~
}
\value{
the HOMFLY polynomial (as string)
%%  ~Describe the value returned
%%  If it is a LIST, use
%% ...
}
\references{
	Freyd P, Yetter D, Hoste J, Lickorish WBR, Millett K, et al.
	 (1985) A new polynomial invariant of knots and links. Bull Amer Math Soc (NS) 12: 239-246.
	
	Kauffman, L. Knots and Physics. Teaneck, NJ: World Scientific, p. 19, 1991.
	
	Comoglio F. and Rinaldi M. (2011) A Topological Framework for the Computation of the HOMFLY Polynomial and Its Application to Proteins 
	PLoS ONE 6(4): e18693, doi:10.1371/journal.pone.0018693 
	ArXiv:1104.3405
%% ~put references to the literature/web site here ~
}
\author{
Federico Comoglio
%%  ~~who you are~~
}
\note{
If you wish to compute the polynomial 
directly from the polygonal link points, the function \code{findKnot} 
is what you are looking for. The same applies for the function \code{findProteinKnot}
in the case you are looking for an automated processing of PDB files.
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{findKnot}}
\code{\link{findProteinKnot}}
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
if(require(bio3d)) {
	## Import a PDB file from the file system
	points3D <- fileImport(system.file("extdata/2k0a.pdb", package="Rknots"))

	## Reduce to minimal structure
	points3D <- msr(points3D, c())$points3D

	## Compute the skein tree
	tree.leaves <- skeinIterator(points3D, c())
	
	## Compute the HOMFLY polynomial
	hp <- HOMFLYpolynomial(tree.leaves[[1]], tree.leaves[[2]], -1)
	hp
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{invariants}
% \keyword{ ~kwd2 }% __ONLY ONE__ keyword per line