% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-effect.R
\name{adjusted_effect}
\alias{adjusted_effect}
\title{Compute adjusted effect size}
\usage{
adjusted_effect(
  object,
  conditional = FALSE,
  output_scale = NULL,
  probs = c(0.025, 0.975),
  as_samples = FALSE
)
}
\arguments{
\item{object}{a fitted RoBMA object}

\item{conditional}{show the conditional estimates (assuming that the
alternative is true). Defaults to \code{FALSE}. Only available for
\code{type == "ensemble"}.}

\item{output_scale}{transform the  meta-analytic estimates to a different
scale. Defaults to \code{NULL} which returns the same scale as the model was estimated on.}

\item{probs}{quantiles of the posterior samples to be displayed.
Defaults to \code{c(.025, .975)}}

\item{as_samples}{whether posterior samples instead of a summary table should
be returned. Defaults to \code{FALSE}.}
}
\value{
\code{pooled_effect} returns a list of tables of class 'BayesTools_table'.
}
\description{
\code{adjusted_effect} computes the adjusted effect size
for a fitted RoBMA.reg and BiBMA.reg object. Only available for models
estimated using the spike-and-slab algorithm (i.e., \code{algorithm = "ss"}).
}
\details{
Non-default meta-regression specification (i.e., using treatment contrasts for
predictors) might results in the intercept corresponding
to the effect estimate in the baseline group. (i.e., adjusting for the effect of moderators).
The adjusted effect size function averages the effect size estimate across the moderators
levels. Note that there is no Bayes factor test for the presence of the adjusted effect
(the summary function provides the effect estimate in the baseline group and the test for the
presence of the effect in the baseline group if a treatment contrasts are specified).

The conditional estimate is calculated conditional on the presence of the baseline group
effect (i.e., the intercept).
}
\seealso{
\code{\link[=pooled_effect]{pooled_effect()}}
}
