% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_effect.R
\name{surv_effect_methods}
\alias{surv_effect_methods}
\alias{print.surv_effect}
\alias{table}
\alias{table.default}
\alias{table.surv_effect}
\title{S3 Methods for \code{surv_effect}}
\usage{
\method{print}{surv_effect}(x, ...)

table(x, ...)

\method{table}{default}(x, ...)

\method{table}{surv_effect}(x, ...)
}
\arguments{
\item{x}{(\code{surv_effect}) the obtained result from \code{\link[=robin_surv]{robin_surv()}}.}

\item{...}{ignored additional arguments (for compatibility).}
}
\description{
S3 Methods for \code{surv_effect}
}
\section{Functions}{
\itemize{
\item \code{print(surv_effect)}: prints the \code{surv_effect} object.

\item \code{table(surv_effect)}: prints and returns invisibly the events table of the \code{surv_effect} object.

}}
\examples{
x <- robin_surv(
  formula = Surv(time, status) ~ meal.cal + age,
  data = surv_data,
  treatment = sex ~ strata
)
print(x)
table(x)
}
