% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SearchingSampling.R
\name{SearchingSampling}
\alias{SearchingSampling}
\title{Searching-Sampling}
\usage{
SearchingSampling(
  Y,
  D,
  Z,
  X = NULL,
  intercept = TRUE,
  method = c("OLS", "DeLasso", "Fast.DeLasso"),
  robust = FALSE,
  Sampling = TRUE,
  alpha = 0.05,
  CI.init = NULL,
  a = 0.6,
  rho = NULL,
  M = 1000,
  prop = 0.1,
  filtering = TRUE,
  tuning.1st = NULL,
  tuning.2nd = NULL
)
}
\arguments{
\item{Y}{The outcome observation, a vector of length \eqn{n}.}

\item{D}{The treatment observation, a vector of length \eqn{n}.}

\item{Z}{The instrument observation of dimension \eqn{n \times p_z}.}

\item{X}{The covariates observation of dimension \eqn{n \times p_x}.}

\item{intercept}{Whether the intercept is included. (default = \code{TRUE})}

\item{method}{The method used to estimate the reduced form parameters. \code{"OLS"} stands for ordinary least squares, \code{"DeLasso"} stands for the debiased Lasso estimator, and \code{"Fast.DeLasso"} stands for the debiased Lasso estimator with fast algorithm. (default = \code{"OLS"})}

\item{robust}{If \code{TRUE}, the method is robust to heteroskedastic errors. If \code{FALSE}, the method assumes homoskedastic errors.  (default = \code{FALSE})}

\item{Sampling}{If \code{TRUE}, use the proposed sampling method; else use the proposed searching method. (default=\code{TRUE})}

\item{alpha}{The significance level (default=\code{0.05})}

\item{CI.init}{An initial range for beta. If \code{NULL}, it will be generated automatically. (default=\code{NULL})}

\item{a}{The grid size for constructing beta grids. (default=\code{0.6})}

\item{rho}{The shrinkage parameter for the sampling method. (default=\code{NULL})}

\item{M}{The resampling size for the sampling method. (default = \code{1000})}

\item{prop}{The proportion of non-empty intervals used for the sampling method. (default=\code{0.1})}

\item{filtering}{Filtering the resampled data or not. (default=\code{TRUE})}

\item{tuning.1st}{The tuning parameter used in the 1st stage to select relevant instruments. If \code{NULL}, it will be generated data-dependently, see Details. (default=\code{NULL})}

\item{tuning.2nd}{The tuning parameter used in the 2nd stage to select valid instruments. If \code{NULL}, it will be generated data-dependently, see Details. (default=\code{NULL})}
}
\value{
\code{SearchingSampling} returns an object of class "SS", which is a list containing the following components:
\item{ci}{1-alpha confidence interval for beta.}
\item{SHat}{The set of selected relevant IVs.}
\item{VHat}{The initial set of selected relevant and valid IVs.}
\item{check}{The indicator that the plurality rule is satisfied.}
}
\description{
Construct Searching and Sampling confidence intervals for the causal effect, which provides the robust inference of the treatment effect in the presence of invalid instrumental variables in both low-dimensional and high-dimensional settings. It is robust to the mistakes in separating valid and invalid instruments.
}
\details{
When \code{robust = TRUE}, the \code{method} will be input as \code{’OLS’}. For \code{rho}, \code{M}, \code{prop}, and \code{filtering}, they are required only for \code{Sampling = TRUE}.
As for tuning parameter in the 1st stage and 2nd stage, if do not specify, for method "OLS" we adopt \eqn{\sqrt{\log n}} for both tuning parameters, and for other methods
we adopt \eqn{\max{(\sqrt{2.01 \log p_z}, \sqrt{\log n})}} for both tuning parameters.
}
\examples{

data("lineardata")
Y <- lineardata[,"Y"]
D <- lineardata[,"D"]
Z <- as.matrix(lineardata[,c("Z.1","Z.2","Z.3","Z.4","Z.5","Z.6","Z.7","Z.8")])
X <- as.matrix(lineardata[,c("age","sex")])
Searching.model <- SearchingSampling(Y,D,Z,X, Sampling = FALSE)
summary(Searching.model)
Sampling.model <- SearchingSampling(Y,D,Z,X)
summary(Sampling.model)


}
\references{
{
Guo, Z. (2021), Causal Inference with Invalid Instruments: Post-selection Problems and A Solution Using Searching and Sampling, Preprint \emph{arXiv:2104.06911}. \cr
}
}
