% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneandtrainExtBoost.R
\name{tuneandtrainExtBoost}
\alias{tuneandtrainExtBoost}
\title{Tune and Train External Boosting}
\usage{
tuneandtrainExtBoost(data, dataext, mstop_seq = seq(5, 1000, by = 5), nu = 0.1)
}
\arguments{
\item{data}{A data frame containing the training data. The first column should be the 
response variable (factor), and the remaining columns should be the predictor 
variables.}

\item{dataext}{A data frame containing the external validation data. The first column 
should be the response variable (factor), and the remaining columns should be the 
predictor variables.}

\item{mstop_seq}{A numeric vector of boosting iterations to be evaluated. Default is a 
sequence starting at 5 and increasing by 5 each time, up to 1000.}

\item{nu}{A numeric value for the learning rate. Default is 0.1.}
}
\value{
A list containing the best number of boosting iterations (`best_mstop`), 
  the final trained model (`best_model`), and the AUC of the final model (`final_auc`).
}
\description{
This function tunes and trains a Boosting classifier using the \code{mboost::glmboost} 
function. The function evaluates a sequence of boosting iterations (mstop) on the 
provided external validation dataset and selects the best model based on the AUC (Area Under the Curve) metric.
}
\details{
The function first fits an initial Boosting model on the training data using the specified
learning rate (\code{nu}) and evaluates different values of \code{mstop} on the external validation set.
The \code{mstop} value with the highest AUC is chosen as the best model, and the final model is trained
using this optimal \code{mstop}.
}
\examples{
# Load sample data
data(sample_data_train)
data(sample_data_extern)

# Example usage
mstop_seq <- seq(50, 500, by = 50)
result <- tuneandtrainExtBoost(sample_data_train, sample_data_extern, 
  mstop_seq = mstop_seq, nu = 0.1)
result$best_mstop
result$best_model
result$final_auc
}
