\name{SF.asDecisionTable}
\alias{SF.asDecisionTable}
\title{The construction function}
\usage{
  SF.asDecisionTable(dataset, decision.attr = NULL,
    indx.nominal = NULL)
}
\arguments{
  \item{dataset}{a data frame representing the dataset that
  contains objects/instances and attributes/features in its
  rows and columns, respectively.  See in Section
  \code{Details}.}

  \item{decision.attr}{a numeric value representing the
  index position of the decision attribute. If we ignore
  this parameter, then the function will treat the data as
  an information system or newdata/testing data. In other
  words, we must define the index of decision attribute if
  we have the decision attribute in the dataset.}

  \item{indx.nominal}{a vector representing indexes of
  nominal values. It is used to define specific indexes as
  nominal attributes.}
}
\value{
  A \code{"DecisionTable"} class which is the standard
  decision table.
}
\description{
  It is a function used to construct a standard decision
  table in the \code{RoughSets} package. So, users are
  strongly recommended to call this function first before
  any other functions in this package.
}
\details{
  The \code{RoughSets} package requires a standard decision
  table to calculate a particular task. The standard
  decision table is a \code{"DecisionTable"} class which
  constitutes the set of all objects/instances (universe of
  discourse) and other attributes. The objects are built by
  a table or data frame where the number of rows and
  columns represent the number of objects/instances and
  attributes, respectively. Three important attributes that
  describe the decision table are as follows. \itemize{
  \item \code{desc.attrs}: a list containing the names of
  attributes and range of the data. There are two kinds of
  representation in this parameters which depend on whether
  the attributes are in symbolic/nominal or real values,
  for example: \itemize{ \item symbolic/nominal attribute:
  \code{a = c(1,2,3)} means the attribute \code{a} has
  values 1, 2, and 3.  \item real/continuous attribute:
  \code{a = c(10, 20)} means the attribute \code{a} has
  values between 10 and 20.  } \item \code{nominal.attrs}:
  a vector containing boolean values that show whether the
  related attributes is a nominal value or not.  For
  example:

  \code{nominal.attrs = c(FALSE, TRUE, FALSE)} means that
  the first and third attributes are continuous attributes
  and otherwise for the second one.  \item
  \code{decision.attr}: a numeric value representing an
  index of the decision attribute. Users must define the
  index of the decision attribute when they want to
  construct a decision table or training dataset. But, it
  is a null value when constructing a testing
  dataset/newdata.  It is strongly recommended that the
  index of decision attribute is put on the last column of
  the dataset. } It also has been provided the function
  \code{\link{SF.read.DecisionTable}} which is used to
  import from a file and then construct into the decision
  table.
}
\examples{
################################################################
## Example : converting from datasets in data.frame
##            into decision table
################################################################
## Let use iris which is available in R be dataset
decision.table <- SF.asDecisionTable(dataset = iris, decision.attr = 5,
                  indx.nominal = 5)
}

