% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RuleInduction.R
\name{predict.RuleSetFRST}
\alias{predict.FRST}
\alias{predict.RuleSetFRST}
\title{The predicting function for rule induction methods based on FRST}
\usage{
\method{predict}{RuleSetFRST}(object, newdata, ...)
}
\arguments{
\item{object}{a \code{"RuleSetFRST"} class resulted by \code{\link{RI.GFRS.FRST}} and \code{\link{RI.hybridFS.FRST}}.}

\item{newdata}{a \code{"DecisionTable"} class containing a data frame or matrix (m x n) of data for the prediction process, where m is the number of instances and
n is the number of input attributes. It should be noted that this data must have \code{colnames} on each attributes.}

\item{...}{the other parameters.}
}
\value{
The predicted values.
}
\description{
It is a function used to obtain predicted values after obtaining rules by using rule induction methods.
We have provided the functions \code{\link{RI.GFRS.FRST}} and \code{\link{RI.hybridFS.FRST}} to generate rules based on FRST.
}
\examples{
##############################################
## Example: Classification Task
##############################################
data(RoughSetData)
decision.table <- RoughSetData$pima7.dt

## using RI.hybrid.FRST for generating rules
control <- list(type.aggregation = c("t.tnorm", "lukasiewicz"),
           type.relation = c("tolerance", "eq.1"), t.implicator = "lukasiewicz")
rules.hybrid <- RI.hybridFS.FRST(decision.table, control)

## in this case, we are using the same data set as the training data
res.1 <- predict(rules.hybrid, decision.table[, -ncol(decision.table)])

## using RI.GFRS.FRST for generating rules
control <- list(alpha.precision = 0.01, type.aggregation = c("t.tnorm", "lukasiewicz"),
                type.relation = c("tolerance", "eq.3"), t.implicator = "lukasiewicz")
rules.gfrs <- RI.GFRS.FRST(decision.table, control)

## in this case, we are using the same data set as the training data
res.2 <- predict(rules.gfrs, decision.table[, -ncol(decision.table)])

##############################################
## Example: Regression Task
##############################################
data(RoughSetData)
decision.table <- RoughSetData$housing7.dt

## using RI.hybrid.FRST for generating rules
control <- list(type.aggregation = c("t.tnorm", "lukasiewicz"),
           type.relation = c("tolerance", "eq.1"), t.implicator = "lukasiewicz")
rules <- RI.hybridFS.FRST(decision.table, control)

## in this case, we are using the same data set as the training data
res.1 <- predict(rules, decision.table[, -ncol(decision.table)])
}
\author{
Lala Septem Riza
}
\seealso{
\code{\link{RI.indiscernibilityBasedRules.RST}}, \code{\link{RI.GFRS.FRST}} and \code{\link{RI.hybridFS.FRST}}
}

