% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FeatureSelection.R
\name{FS.one.reduct.computation}
\alias{FS.one.reduct.computation}
\title{Computing one reduct from a discernibility matrix}
\usage{
FS.one.reduct.computation(discernibilityMatrix, greedy = TRUE,
  power = 1)
}
\arguments{
\item{discernibilityMatrix}{a \code{"DiscernibilityMatrix"} class representing the discernibility matrix of RST and FRST.}

\item{greedy}{a boolean value indicating whether the greedy heuristic or a randomized search should be used in computations.}

\item{power}{a numeric representing a parameter of the randomized search heuristic.}
}
\value{
An object of a class \code{"ReductSet"}.
}
\description{
It is a function for computing one reduct from a discernibility matrix - it can use
the greedy heuristic or a randomized (Monte Carlo) search.
}
\examples{
########################################################
## Example 1: Generate one reduct and
##            a new decision table using RST
########################################################
data(RoughSetData)
decision.table <- RoughSetData$hiring.dt

## build the decision-relation discernibility matrix
res.1 <- BC.discernibility.mat.RST(decision.table)

## generate all reducts
reduct <- FS.one.reduct.computation(res.1)

## generate new decision table
new.decTable <- SF.applyDecTable(decision.table, reduct, control = list(indx.reduct = 1))

##############################################################
## Example 2: Generate one reduct and
##            a new decision table using FRST
##############################################################
data(RoughSetData)
decision.table <- RoughSetData$hiring.dt

## build the decision-relative discernibility matrix
control <- list(type.relation = c("crisp"),
                type.aggregation = c("crisp"),
                t.implicator = "lukasiewicz", type.LU = "implicator.tnorm")
res.2 <- BC.discernibility.mat.FRST(decision.table, type.discernibility = "standard.red",
                                    control = control)

## generate a single reduct
reduct <- FS.one.reduct.computation(res.2)

## generate new decision table
new.decTable <- SF.applyDecTable(decision.table, reduct, control = list(indx.reduct = 1))
}
\references{
Jan G. Bazan, Hung Son Nguyen, Sinh Hoa Nguyen, Piotr Synak, and Jakub Wroblewski,
"Rough Set Algorithms in Classification Problem", Chapter 2
In: L. Polkowski, S. Tsumoto and T.Y. Lin (eds.): Rough Set Methods and Applications
Physica-Verlag, Heidelberg, New York, p. 49 - 88 ( 2000).
}
\seealso{
\code{\link{BC.discernibility.mat.RST}} and \code{\link{BC.discernibility.mat.FRST}}.
}
\author{
Andrzej Janusz
}
