% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activitytypes.add.R
\name{activitytypes.add}
\alias{activitytypes.add}
\title{Add new activity type}
\usage{
activitytypes.add(name, icon_key, color = NULL, api_token = NULL,
  company_domain = "api", return_type = c("complete", "boolean"))
}
\arguments{
\item{name}{Name of the activity type}

\item{icon_key}{Icon graphic to use for representing this activity type. This field has the following domains: (task; email; meeting; deadline; call; lunch; calendar; downarrow; document; smartphone; camera; scissors; cogs; bubble; uparrow; checkbox; signpost; shuffle; addressbook; linegraph; picture; car; world; search; clip; sound; brush; key; padlock; pricetag; suitcase; finish; plane; loop; wifi; truck; cart; bulb; bell; presentation)}

\item{color}{A designated color for the activity type in 6-character HEX format (e.g. FFFFFF for white, 000000 for black).}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}

\item{return_type}{the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)}
}
\value{
customizable return, the default is an object List
}
\description{
Function to Add new activity type on pipedrive.
}
\examples{
\donttest{
activitytypes.add(name='e.g.',icon_key='e.g.',api_token='token',company_domain='exp')
}
}
