% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activitytypes.update.R
\name{activitytypes.update}
\alias{activitytypes.update}
\title{Edit activity type}
\usage{
activitytypes.update(id, name = NULL, icon_key = NULL, color = NULL,
  order_nr = NULL, api_token = NULL, company_domain = "api",
  return_type = c("complete", "boolean"))
}
\arguments{
\item{id}{ID of the activity type}

\item{name}{Name of the activity type}

\item{icon_key}{Icon graphic to use. Supported values: default, call, meeting, lunch, email, task, deadline. Additional supported values will be made available in the future.}

\item{color}{A designated color for the activity type in 6-character HEX format (e.g. FFFFFF for white, 000000 for black).}

\item{order_nr}{An order number for this activity type. Order numbers should be used to order the types in the activity type selections.}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}

\item{return_type}{the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)}
}
\value{
customizable return, the default is an object List
}
\description{
Function to Edit activity type on pipedrive.
}
\examples{
\donttest{
activitytypes.update(id='e.g.',api_token='token',company_domain='exp')
}
}
